/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.ant;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.titan.common.utils.FileUtils;
import org.eclipse.titan.designer.compiler.ProjectSourceCompiler;

public final class JavaAppLaunchConfigGenerator {
    private static final String TEMPORARY_LAUNCH_CONFIGURATION_NAME = "tempJavaAppLaunchConfig";

    public static ILaunchConfiguration createTemporaryJavaAppLaunchConfiguration(IProject project) throws CoreException {
        ILaunchConfiguration[] configs;
        if (project == null) {
            return null;
        }
        ILaunchConfiguration tempConfig = null;
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType type = JavaAppLaunchConfigGenerator.getJavaAppLaunchConfigurationType();
        for (ILaunchConfiguration config : configs = JavaAppLaunchConfigGenerator.getLaunchManager().getLaunchConfigurations(type)) {
            if (!config.getName().equals(TEMPORARY_LAUNCH_CONFIGURATION_NAME)) continue;
            tempConfig = config;
            break;
        }
        if (tempConfig == null) {
            IFolder tempFolder = project.getFolder((IPath)new Path("temp"));
            FileUtils.createDir((IFolder)tempFolder);
            wc = JavaAppLaunchConfigGenerator.getJavaAppLaunchConfigurationType().newInstance((IContainer)tempFolder, JavaAppLaunchConfigGenerator.getLaunchManager().generateLaunchConfigurationName(TEMPORARY_LAUNCH_CONFIGURATION_NAME));
        } else {
            wc = tempConfig.getWorkingCopy();
        }
        String mainType = ProjectSourceCompiler.getPackageGeneratedRoot(project) + ".Parallel_main";
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainType);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        String mainFilePath = ProjectSourceCompiler.getGeneratedRoot(project) + File.separator + "Parallel_main";
        IFile mainFile = project.getFile((IPath)new Path(mainFilePath));
        wc.setMappedResources(new IResource[]{mainFile});
        tempConfig = wc.doSave();
        return tempConfig;
    }

    public static void deleteTemporaryJavaAppLaunchConfiguration(IProject project) throws CoreException {
        if (project == null) {
            return;
        }
        IFile tempConfigFile = project.getFile((IPath)new Path("temp" + File.separator + TEMPORARY_LAUNCH_CONFIGURATION_NAME + ".launch"));
        if (tempConfigFile.exists()) {
            tempConfigFile.delete(true, null);
        }
    }

    public static ILaunchConfiguration findLaunchConfiguration(IProject project) throws CoreException {
        ILaunchConfiguration[] configs;
        if (project == null) {
            return null;
        }
        ILaunchConfigurationType type = JavaAppLaunchConfigGenerator.getJavaAppLaunchConfigurationType();
        for (ILaunchConfiguration config : configs = JavaAppLaunchConfigGenerator.getLaunchManager().getLaunchConfigurations(type)) {
            if (!project.getName().equals(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""))) continue;
            return config;
        }
        return JavaAppLaunchConfigGenerator.createTemporaryJavaAppLaunchConfiguration(project);
    }

    public static ILaunchConfigurationType getJavaAppLaunchConfigurationType() {
        return JavaAppLaunchConfigGenerator.getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

