/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.utils.BundleUtils;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.preferences.PreferenceConstantValues;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public final class ColorManager {
    private static final Map<String, Color> COLOR_TABLE = new HashMap<String, Color>(10);
    private static final Map<String, Token> TOKEN_TABLE = new HashMap<String, Token>();
    private static final String INFORMATION_BACKGROUND_COLOR = "org.eclipse.ui.workbench.INFORMATION_BACKGROUND";

    public Color getForegroundColor(String aName, IPreferenceStore store) {
        Color color;
        Color color2 = color = store == Activator.getDefault().getPreferenceStore() ? COLOR_TABLE.get(aName) : null;
        if (color == null) {
            RGB rgb = ColorManager.getColor(store, aName);
            color = rgb == null ? ColorManager.getDisplay().getSystemColor(24) : new Color((Device)ColorManager.getDisplay(), rgb);
            if (store == Activator.getDefault().getPreferenceStore()) {
                COLOR_TABLE.put(aName, color);
            }
        }
        return color;
    }

    public Color getBackgroundColor(String aName, IPreferenceStore store) {
        Color color;
        Color color2 = color = store == Activator.getDefault().getPreferenceStore() ? COLOR_TABLE.get(aName) : null;
        if (color == null) {
            RGB rgb = ColorManager.getColor(store, aName);
            color = rgb == null ? ColorManager.getDisplay().getSystemColor(1) : new Color((Device)ColorManager.getDisplay(), rgb);
            if (store == Activator.getDefault().getPreferenceStore()) {
                COLOR_TABLE.put(aName, color);
            }
        }
        return color;
    }

    public TextAttribute createAttributeFromPreference(String key) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        Color foregroundColor = this.getForegroundColor(key + ".foreground", store);
        Color backgroundColor = store.getBoolean(key + ".usebackgroundcolor") ? this.getBackgroundColor(key + ".background", store) : null;
        int style = 0;
        if (store.getBoolean(key + ".bold")) {
            style |= 1;
        }
        if (store.getBoolean(key + ".italic")) {
            style |= 2;
        }
        if (store.getBoolean(key + ".strikethrough")) {
            style |= 0x20000000;
        }
        if (store.getBoolean(key + ".underline")) {
            style |= 0x40000000;
        }
        return new TextAttribute(foregroundColor, backgroundColor, style != 0 ? style : 0);
    }

    public Token createTokenFromPreference(String key) {
        if (TOKEN_TABLE.containsKey(key)) {
            return TOKEN_TABLE.get(key);
        }
        Token temp = new Token((Object)this.createAttributeFromPreference(key));
        TOKEN_TABLE.put(key, temp);
        return temp;
    }

    public StyleRange createStyleRangeFromPreference(String key, IPreferenceStore prefStore, int start, int length) {
        IPreferenceStore store = prefStore != null ? prefStore : Activator.getDefault().getPreferenceStore();
        Color foregroundColor = this.getForegroundColor(key + ".foreground", store);
        Color backgroundColor = store.getBoolean(key + ".usebackgroundcolor") ? this.getBackgroundColor(key + ".background", store) : null;
        int style = 0;
        if (store.getBoolean(key + ".bold")) {
            style |= 1;
        }
        if (store.getBoolean(key + ".italic")) {
            style |= 2;
        }
        StyleRange sr = new StyleRange(start, length, foregroundColor, backgroundColor, style);
        sr.strikeout = store.getBoolean(key + ".strikethrough");
        sr.underline = store.getBoolean(key + ".underline");
        return sr;
    }

    public void update(String key) {
        String baseKey = null;
        if (key.endsWith(".foreground")) {
            baseKey = key.substring(0, key.length() - ".foreground".length());
        } else if (key.endsWith(".background")) {
            baseKey = key.substring(0, key.length() - ".background".length());
        } else if (key.endsWith(".usebackgroundcolor")) {
            baseKey = key.substring(0, key.length() - ".usebackgroundcolor".length());
        } else if (key.endsWith(".bold")) {
            baseKey = key.substring(0, key.length() - ".bold".length());
        } else if (key.endsWith(".italic")) {
            baseKey = key.substring(0, key.length() - ".italic".length());
        } else if (key.endsWith(".strikethrough")) {
            baseKey = key.substring(0, key.length() - ".strikethrough".length());
        } else if (key.endsWith(".underline")) {
            baseKey = key.substring(0, key.length() - ".underline".length());
        }
        if (baseKey != null && TOKEN_TABLE.containsKey(baseKey)) {
            Token tempToken = TOKEN_TABLE.get(baseKey);
            COLOR_TABLE.remove(key);
            tempToken.setData((Object)this.createAttributeFromPreference(baseKey));
        }
    }

    public static Color getInformationBackgroundColor() {
        Version since = new Version(3, 14, 0);
        if (BundleUtils.getJFaceVersion().compareTo(since) >= 0) {
            return JFaceResources.getColorRegistry().get(INFORMATION_BACKGROUND_COLOR);
        }
        return Display.getCurrent().getSystemColor(1);
    }

    public static Theme getColorTheme() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.e4.ui.css.swt.theme");
        String colorTheme = preferences.get("themeid", "default");
        if (colorTheme.toLowerCase().contains("dark")) {
            return Theme.Dark;
        }
        return Theme.Light;
    }

    private static RGB getColor(IPreferenceStore store, String name) {
        return StringConverter.asRGB((String)store.getString(name), null);
    }

    private static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Color getBreadcrumbColor() {
        return new Color((Device)PlatformUI.getWorkbench().getDisplay(), ColorManager.getColorTheme() == Theme.Light ? PreferenceConstantValues.BREADCRUMB_COLOR : PreferenceConstantValues.BREADCRUMB_DARK_COLOR);
    }

    public static enum Theme {
        Light,
        Dark;

    }
}

