/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class GitUtilities {
    private static Image historyIcon = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCommitInfo(IFile file, int line) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceDirectory = workspace.getRoot().getLocation().toFile();
        String parentDir = file.getParent().getFullPath().toOSString();
        String gitPath = workspaceDirectory.getPath() + File.separator + parentDir + File.separator + ".git";
        try {
            Git git = Git.open((File)new File(gitPath));
            Repository repository = git.getRepository();
            if (repository == null) {
                return null;
            }
            StoredConfig config = repository.getConfig();
            String email = config.getString("user", null, "email");
            FileTreeIterator treeIterator = new FileTreeIterator(repository);
            DirCacheIterator cacheIterator = new DirCacheIterator(repository.readDirCache());
            EditList listOfEdits = null;
            try (DiffFormatter diffFormatter2 = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);){
                diffFormatter2.setRepository(git.getRepository());
                List diffEntries = diffFormatter2.scan((AbstractTreeIterator)treeIterator, (AbstractTreeIterator)cacheIterator);
                DiffEntry currentDiffEntry = null;
                for (int i = 0; i < diffEntries.size(); ++i) {
                    if (!((DiffEntry)diffEntries.get(i)).getNewPath().equals(file.getName())) continue;
                    currentDiffEntry = (DiffEntry)diffEntries.get(i);
                    break;
                }
                if (currentDiffEntry != null) {
                    FileHeader fileHeader = diffFormatter2.toFileHeader(currentDiffEntry);
                    listOfEdits = fileHeader.toEditList();
                    for (Edit edit : listOfEdits) {
                        if (edit.getType() != Edit.Type.REPLACE || line != edit.getBeginA() || line != edit.getBeginB()) continue;
                        String string = "You, uncommitted change";
                        return string;
                    }
                }
            }
            catch (Exception diffFormatter2) {
                // empty catch block
            }
            BlameCommand bc = new BlameCommand(repository);
            ObjectId head = repository.resolve("HEAD");
            if (head == null) {
                return null;
            }
            bc.setStartCommit((AnyObjectId)head);
            bc.setFilePath(file.getName());
            BlameResult lines = bc.call();
            if (lines == null) {
                return null;
            }
            PersonIdent author = lines.getSourceAuthor(line);
            String modifiedBy = null;
            modifiedBy = author.getEmailAddress().equals(email) ? "You" : author.getName();
            RevCommit commit = lines.getSourceCommit(line);
            return "[" + modifiedBy + ", " + GitUtilities.timeAgo(author.getWhen()) + "  " + commit.getShortMessage() + "]";
        }
        catch (IOException | GitAPIException throwable) {
            return null;
        }
    }

    private static String timeAgo(Date date) {
        LocalDate now;
        LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
        if (localDate.isAfter((now = LocalDate.now()).minusDays(1L))) {
            return date.toString();
        }
        if (localDate.isAfter(now.minusDays(30L))) {
            long untilDays = localDate.until(now, ChronoUnit.DAYS);
            return untilDays + (untilDays == 1L ? " day" : " days") + " ago ";
        }
        if (localDate.isAfter(now.minusMonths(12L))) {
            long untilMonths = localDate.until(now, ChronoUnit.MONTHS);
            return untilMonths + (untilMonths == 1L ? " month" : " months") + " ago ";
        }
        long untilYears = localDate.until(now, ChronoUnit.YEARS);
        return untilYears + (untilYears == 1L ? " year" : " years") + " ago ";
    }

    public static Image getHistoryIconImage() {
        if (historyIcon != null) {
            return historyIcon;
        }
        historyIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY");
        return historyIcon;
    }
}

