/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchy;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyContentProvider;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyLabelProvider;
import org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyNode;
import org.eclipse.titan.designer.editors.ttcn3editor.actions.CallHierarchyAction;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public final class CallHierarchyView
extends ViewPart
implements ISelectionChangedListener {
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private Table table;
    private SashForm splitter;
    private final CallHierarchyContentProvider contentProvider;
    private final CallHierarchyLabelProvider labelProvider;
    private IStatusLineManager statusLineManager;
    private IActionBars actionBars;
    private Label messageLabel;
    private final CallHierarchy callHierarchy;
    private CallHierarchyNode treeViewerSelectedNode;
    private int focused = 0;
    private int inFocus = 0;
    private static boolean autoJumpToDefinition = true;
    private static boolean showCallList = true;
    private CallHierarchyAction callHierarchyAction;
    private Action searcHistoryAction;
    private Action refreshAction;
    private final String[] columnHeaders = new String[]{"", "Line", "Call"};
    private final int[] columnSizes = new int[]{18, 60, 300};
    private final ColumnLayoutData[] columnLayouts = new ColumnLayoutData[]{new ColumnPixelData(this.columnSizes[0], false, true), new ColumnWeightData(this.columnSizes[1]), new ColumnWeightData(this.columnSizes[2])};
    public static final String viewID = "org.eclipse.titan.designer.editors.ttcn3editor.CallHierarchyView";
    private static final String INITIAL_MESSAGE = "To display the call hierarchy, select one function or testcase\nand choose the 'Open Call Hierarchy' menu option or press Ctrl+Alt+H.";
    private static final String CALLING_IN_PROJECT = "\"{0}\" calls in project: \"{1}\".";
    private static final String EDITOR_OPEN_ERROR = "The new editor can not open!";
    private static final String REFRESH = "Refresh";
    private static final String REFRESH_ICON = "call_hierarchy_search_refresh.gif";
    private static final String JUMP_TO_DEFINITION = "Auto jump to definition";
    private static final String JUMP_TO_DEFINITION_ICON = "call_hierarchy_auto_definition_jump.gif";
    private static final String CALL_LINE_VIEW = "Call line view";
    private static final String CALL_LINE_VIEW_ICON = "call_hierarchy_call_line_view.gif";
    private static final String COLLAPSE_TREE_VIEWER = "Close all";
    private static final String COLLAPSE_TREE_VIEWER_ICON = "call_hierarchy_collapse.gif";
    private static final String SEARCH_HISTORY = "Search history";
    private static final String SEARCH_HISTORYICON = "call_hierarchy_search_history.gif";
    private static final String STATUS_LINE_MESSAGE_ICON = "titan.gif";
    private static final String STATUS_LINE_ERROR_ICON = "compiler_error_fresh.gif";
    private static final String FUNCTION_ICON = "function.gif";
    private static final String TESTCASE_ICON = "testcase.gif";
    private static final String FUNCTION_EXTERNAL_ICON = "function_external.gif";
    private static final int TREE_VIEWER = 0;
    private static final int TABLE_VIEWEVR = 1;
    private static final int STATUS_LINE_LEVEL_MESSAGE = 0;
    private static final int STATUS_LINE_LEVEL_ERROR = 1;
    public final Comparator<Object> getReferenceComparator = new Comparator<Object>(){

        @Override
        public int compare(Object object1, Object object2) {
            Reference reference1 = (Reference)object1;
            Reference reference2 = (Reference)object2;
            if (reference1.getLocation().getLine() < reference2.getLocation().getLine()) {
                return -1;
            }
            if (reference1.getLocation().getLine() > reference2.getLocation().getLine()) {
                return 1;
            }
            return 0;
        }
    };

    public CallHierarchyView() {
        this.callHierarchy = new CallHierarchy();
        this.contentProvider = new CallHierarchyContentProvider(this.callHierarchy);
        this.labelProvider = new CallHierarchyLabelProvider();
    }

    public static CallHierarchyView showView() {
        IViewPart viewPart = null;
        try {
            viewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID);
        }
        catch (PartInitException e) {
            return null;
        }
        if (viewPart == null) {
            return null;
        }
        if (!(viewPart instanceof CallHierarchyView)) {
            return null;
        }
        return (CallHierarchyView)viewPart;
    }

    public void hideView() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this);
    }

    public void reDraw() {
        this.hideView();
        if (this.callHierarchyAction != null && this.callHierarchy.getCurrentNode() != null && this.callHierarchy.getCurrentNode().getNodeDefinition() != null) {
            this.callHierarchyAction.processing(this.callHierarchy.getCurrentNode());
        }
        CallHierarchyView.showView();
    }

    public void setInput(CallHierarchyNode node) {
        this.treeViewer.setInput((Object)node);
        this.treeViewer.refresh();
        if (showCallList) {
            Object[] emptyInput = new Object[]{};
            TableColumn[] column = this.table.getColumns();
            column[0].setWidth(this.columnSizes[0]);
            column[1].setWidth(this.columnSizes[1]);
            column[2].setWidth(this.columnSizes[2]);
            this.tableViewer.setInput((Object)emptyInput);
        }
        this.treeViewerSelectedNode = node;
        this.setMessage(MessageFormat.format(CALLING_IN_PROJECT, this.callHierarchy.getCurrentNode().getName().substring(1), this.callHierarchy.getCurrentProject().getName()));
        if (this.callHierarchy.getSearchLog().size() > 0) {
            this.searcHistoryAction.setEnabled(true);
            this.refreshAction.setEnabled(true);
        }
        this.treeViewer.getControl().forceFocus();
        this.treeViewer.getTree().select(this.treeViewer.getTree().getItem(0));
        if (this.treeViewer.getTree().getItem(0).getData() instanceof CallHierarchyNode && autoJumpToDefinition) {
            CallHierarchyNode selectedNode = (CallHierarchyNode)this.treeViewer.getTree().getItem(0).getData();
            this.selectLocation(selectedNode.getNodeDefinition().getLocation());
        }
    }

    public void createPartControl(Composite parent) {
        this.statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.callHierarchy.setStatusLineManager(this.statusLineManager);
        this.actionBars = this.getViewSite().getActionBars();
        this.setUpActionBars(this.actionBars);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        parent.setLayout((Layout)gridLayout);
        GridData gridDataForLabel = new GridData();
        gridDataForLabel.horizontalAlignment = 4;
        gridDataForLabel.grabExcessHorizontalSpace = true;
        gridDataForLabel.minimumWidth = 100;
        this.messageLabel = new Label(parent, 64);
        this.messageLabel.setLayoutData((Object)gridDataForLabel);
        this.messageLabel.setAlignment(16384);
        this.messageLabel.setText(INITIAL_MESSAGE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        if (showCallList) {
            this.splitter = new SashForm(parent, 0);
            this.splitter.setLayoutData((Object)gridData);
            this.setUpTreeViewer((Composite)this.splitter, gridData);
            this.table = new Table((Composite)this.splitter, 68354);
            this.table.setLayoutData((Object)gridData);
            this.setUpTableViewer(this.table);
        } else {
            this.setUpTreeViewer(parent, gridData);
        }
        this.treeViewer.getControl().setFocus();
    }

    private void setUpActionBars(IActionBars actionBars) {
        this.refreshAction = new Action(REFRESH){

            public void run() {
                CallHierarchyView.this.callHierarchyAction.processing(CallHierarchyView.this.callHierarchy.getCurrentNode());
            }
        };
        this.refreshAction.setImageDescriptor(ImageCache.getImageDescriptor(REFRESH_ICON));
        this.refreshAction.setEnabled(false);
        actionBars.getToolBarManager().add((IAction)this.refreshAction);
        Action jumpToDefinitionAction = new Action(JUMP_TO_DEFINITION){

            public void run() {
                autoJumpToDefinition = this.isChecked();
            }
        };
        jumpToDefinitionAction.setImageDescriptor(ImageCache.getImageDescriptor(JUMP_TO_DEFINITION_ICON));
        jumpToDefinitionAction.setChecked(autoJumpToDefinition);
        actionBars.getToolBarManager().add((IAction)jumpToDefinitionAction);
        Action hideCallListAction = new Action(CALL_LINE_VIEW){

            public void run() {
                showCallList = this.isChecked();
                CallHierarchyView.this.reDraw();
            }
        };
        hideCallListAction.setImageDescriptor(ImageCache.getImageDescriptor(CALL_LINE_VIEW_ICON));
        hideCallListAction.setChecked(showCallList);
        actionBars.getToolBarManager().add((IAction)hideCallListAction);
        Action collapseTreeViewerAction = new Action(COLLAPSE_TREE_VIEWER){

            public void run() {
                CallHierarchyView.this.treeViewer.collapseAll();
                CallHierarchyView.this.treeViewer.expandToLevel(2);
            }
        };
        collapseTreeViewerAction.setImageDescriptor(ImageCache.getImageDescriptor(COLLAPSE_TREE_VIEWER_ICON));
        actionBars.getToolBarManager().add((IAction)collapseTreeViewerAction);
        this.searcHistoryAction = new Action(SEARCH_HISTORY, 4){};
        this.searcHistoryAction.setMenuCreator((IMenuCreator)new SearchHistoryMenuCreator());
        this.searcHistoryAction.setImageDescriptor(ImageCache.getImageDescriptor(SEARCH_HISTORYICON));
        this.searcHistoryAction.setEnabled(false);
        actionBars.getToolBarManager().add((IAction)this.searcHistoryAction);
    }

    private void setUpTreeViewer(Composite parent, GridData gridData) {
        this.treeViewer = new TreeViewer(parent, 2050);
        this.treeViewer.getTree().setLayoutData((Object)gridData);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void setUpTableViewer(final Table table) {
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CallHierarchyLabelProvider());
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TableLayout tableLayout = new TableLayout();
        this.tableViewer.getTable().setLayout((Layout)tableLayout);
        this.tableViewer.getTable().setHeaderVisible(true);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (int i = 0; i < this.columnHeaders.length; ++i) {
            tableLayout.addColumnData(this.columnLayouts[i]);
            TableColumn tableColumn = new TableColumn(table, 0, i);
            tableColumn.setResizable(this.columnLayouts[i].resizable);
            tableColumn.setText(this.columnHeaders[i]);
            tableColumns.add(tableColumn);
        }
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int sortDirection = table.getSortDirection();
                Object[] references = CallHierarchyView.this.treeViewerSelectedNode.getReferences();
                if (references == null) {
                    return;
                }
                if (sortDirection == 128) {
                    sortDirection = 1024;
                    Arrays.sort(references, CallHierarchyView.this.getReferenceComparator.reversed());
                } else {
                    sortDirection = 128;
                    Arrays.sort(references, CallHierarchyView.this.getReferenceComparator);
                }
                table.setSortDirection(sortDirection);
                CallHierarchyView.this.tableViewer.setInput((Object)references);
            }
        };
        ((TableColumn)tableColumns.get(1)).addListener(13, sortListener);
        table.setSortColumn((TableColumn)tableColumns.get(1));
        table.setSortDirection(128);
    }

    private void tableViewerUpdate(Object selectedElement) {
        this.treeViewerSelectedNode = (CallHierarchyNode)selectedElement;
        Object[] references = this.treeViewerSelectedNode.getReferences();
        int sortDirection = this.table.getSortDirection();
        if (sortDirection == 128) {
            Arrays.sort(references, this.getReferenceComparator);
        } else {
            Arrays.sort(references, this.getReferenceComparator.reversed());
        }
        this.tableViewer.setInput((Object)references);
    }

    public void setFocus() {
        if (this.focused == this.inFocus) {
            return;
        }
        if (this.inFocus == 0) {
            this.focused = 0;
            this.treeViewer.getControl().setFocus();
        }
        if (this.inFocus == 1 && showCallList) {
            this.focused = 1;
            this.tableViewer.getControl().setFocus();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
        if (selectedElement instanceof CallHierarchyNode && showCallList) {
            this.tableViewerUpdate(selectedElement);
            this.inFocus = 0;
        }
        if (selectedElement instanceof Reference) {
            this.inFocus = 1;
        }
        if (!autoJumpToDefinition && !(selectedElement instanceof Reference)) {
            return;
        }
        Location location = this.getEventLocation(selectedElement);
        if (location == null) {
            return;
        }
        this.selectLocation(location);
    }

    private void selectLocation(Location location) {
        if (location == null) {
            return;
        }
        IFile selectedFile = (IFile)location.getFile().getAdapter(IFile.class);
        boolean isFileAlredyOpened = false;
        IEditorReference openedEditor = null;
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        for (int i = 0; i < editorReferences.length; ++i) {
            if (!editorReferences[i].getName().equals(selectedFile.getName())) continue;
            isFileAlredyOpened = true;
            openedEditor = editorReferences[i];
            break;
        }
        if (isFileAlredyOpened) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().bringToTop(openedEditor.getPart(true));
        } else {
            FileEditorInput input = new FileEditorInput(selectedFile);
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)input, "org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor");
            }
            catch (PartInitException e) {
                this.showStatusLineMessage(EDITOR_OPEN_ERROR, 1);
                return;
            }
            CallHierarchyView.showView();
        }
        IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ITextEditor editor = (ITextEditor)targetEditor;
        editor.selectAndReveal(location.getOffset(), location.getEndOffset() - location.getOffset());
    }

    private Location getEventLocation(Object selectedElement) {
        Location location = null;
        if (selectedElement instanceof CallHierarchyNode) {
            this.treeViewerSelectedNode = (CallHierarchyNode)selectedElement;
            location = this.treeViewerSelectedNode.getNodeDefinition().getLocation();
        }
        if (selectedElement instanceof Reference) {
            Reference reference = (Reference)selectedElement;
            location = reference.getLocation();
        }
        return location;
    }

    public CallHierarchy getCallHierarchy() {
        return this.callHierarchy;
    }

    public void setAction(CallHierarchyAction callHierarchyAction) {
        this.callHierarchyAction = callHierarchyAction;
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
        this.messageLabel.getParent().layout();
    }

    public void setMessageVisible(boolean visible) {
        this.messageLabel.setVisible(visible);
        this.messageLabel.getParent().layout();
    }

    public void showStatusLineMessage(String message) {
        this.showStatusLineMessage(message, 0);
    }

    public void showStatusLineMessage(String message, int level) {
        if (this.statusLineManager == null) {
            return;
        }
        this.statusLineManager.setErrorMessage(null);
        if (level == 0) {
            this.statusLineManager.setMessage(ImageCache.getImage(STATUS_LINE_MESSAGE_ICON), message);
        }
        if (level == 1) {
            this.statusLineManager.setMessage(ImageCache.getImage(STATUS_LINE_ERROR_ICON), message);
        }
    }

    private class SearchHistoryMenuCreator
    implements IMenuCreator {
        private Menu menu;

        private SearchHistoryMenuCreator() {
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
                this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            ArrayList<CallHierarchyNode> searchLog = CallHierarchyView.this.callHierarchy.getSearchLog();
            for (int i = searchLog.size() - 1; i >= 0; --i) {
                String iconName;
                final CallHierarchyNode currentLogItem = searchLog.get(i);
                MenuItem menuItem = new MenuItem(this.menu, 8);
                menuItem.setText(currentLogItem.getName().substring(1));
                switch (currentLogItem.getNodeDefinition().getAssignmentType()) {
                    case A_FUNCTION: 
                    case A_FUNCTION_RVAL: 
                    case A_FUNCTION_RTEMP: {
                        iconName = CallHierarchyView.FUNCTION_ICON;
                        break;
                    }
                    case A_TESTCASE: {
                        iconName = CallHierarchyView.TESTCASE_ICON;
                        break;
                    }
                    case A_EXT_FUNCTION: 
                    case A_EXT_FUNCTION_RVAL: 
                    case A_EXT_FUNCTION_RTEMP: {
                        iconName = CallHierarchyView.FUNCTION_EXTERNAL_ICON;
                        break;
                    }
                    default: {
                        iconName = CallHierarchyView.STATUS_LINE_MESSAGE_ICON;
                    }
                }
                menuItem.setImage(ImageCache.getImageDescriptor(iconName).createImage());
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        CallHierarchyView.this.callHierarchyAction.processing(currentLogItem);
                    }
                });
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    }
}

