/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.ttcn3editor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.editors.referenceSearch.ReferenceSearchQuery;

public class HeaderCodeMining
extends LineHeaderCodeMining {
    private final String text;
    private final Image image;
    private final Object data;
    private final Consumer<MouseEvent> action = new Consumer<MouseEvent>(){

        @Override
        public void accept(MouseEvent t) {
            if (HeaderCodeMining.this.data instanceof Definition) {
                ReferenceFinder finder = new ReferenceFinder((Assignment)HeaderCodeMining.this.data);
                Definition definition = (Definition)HeaderCodeMining.this.data;
                ReferenceSearchQuery query = new ReferenceSearchQuery(finder, null, definition.getLocation().getFile().getProject());
                for (ISearchQuery runningQuery : NewSearchUI.getQueries()) {
                    NewSearchUI.cancelQuery((ISearchQuery)runningQuery);
                }
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
        }
    };

    public HeaderCodeMining(int beforeLineNumber, IDocument document, ICodeMiningProvider provider, Object data, String text) throws BadLocationException {
        super(beforeLineNumber - 1, document, provider);
        this.data = data;
        this.text = text;
        this.image = null;
    }

    public HeaderCodeMining(int beforeLineNumber, IDocument document, ICodeMiningProvider provider, Object data, String text, Image image) throws BadLocationException {
        super(beforeLineNumber - 1, document, provider);
        this.data = data;
        this.text = text;
        this.image = image;
    }

    protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.runAsync(() -> super.setLabel(this.text));
    }

    public Point draw(GC gc, StyledText textWidget, Color color, int x, int y) {
        String title;
        FontData fontData = JFaceResources.getDefaultFont().getFontData()[0];
        fontData.setHeight(8);
        Font miningFont = new Font((Device)Display.getDefault(), fontData);
        gc.setFont(miningFont);
        String string = title = this.getLabel() != null ? this.getLabel() : "no command";
        if (this.image != null) {
            gc.drawImage(this.image, x, y + 4);
        }
        gc.drawString(title, this.image != null ? x + 20 : x, y, true);
        Point extent = gc.stringExtent(title);
        if (this.image != null) {
            extent.x += this.image.getBounds().width;
            extent.y += this.image.getBounds().height;
        }
        miningFont.dispose();
        return extent;
    }

    public Consumer<MouseEvent> getAction() {
        return this.action;
    }
}

