/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.graphics;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.TTCN3.types.BitString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CharString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Float_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.HexString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Integer_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.OctetString_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ImageCache {
    private static final String ICONS_SUBDIR = "icons/";
    private static Map<ImageDescriptor, Image> imageCache = new ConcurrentHashMap<ImageDescriptor, Image>();
    private static Map<IType.Type_type, String> typeCache = new HashMap<IType.Type_type, String>();

    private ImageCache() {
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.titan.designer", (String)(ICONS_SUBDIR + name));
    }

    public static Image getImage(String name) {
        ImageDescriptor descriptor = ImageCache.getImageDescriptor(name);
        if (descriptor == null) {
            return null;
        }
        if (imageCache.containsKey(descriptor)) {
            return imageCache.get(descriptor);
        }
        Image image = descriptor.createImage();
        imageCache.put(descriptor, image);
        return image;
    }

    public static Image getImageByType(IType.Type_type tt) {
        return typeCache.containsKey((Object)tt) ? ImageCache.getImage(typeCache.get((Object)tt)) : null;
    }

    static {
        typeCache.put(IType.Type_type.TYPE_BOOL, new Boolean_Type().getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_BITSTRING, new BitString_Type().getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_CHARSTRING, new CharString_Type().getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_COMPONENT, new Component_Type(null).getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_TTCN3_ENUMERATED, new TTCN3_Enumerated_Type(null).getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_HEXSTRING, new HexString_Type().getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_INTEGER, new Integer_Type().getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_OCTETSTRING, new OctetString_Type().getOutlineIcon());
        typeCache.put(IType.Type_type.TYPE_REAL, new Float_Type().getOutlineIcon());
    }
}

