/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileBuildPropertyData {
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"ttcn", "ttcn3", "ttcnin", "ttcnpp", "asn", "asn1"};
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.File";
    public static final String FILERESOURCEXMLNODE = "FileResource";
    public static final String FILEPATHXMLNODE = "FilePath";
    public static final String FILEPROPERTIESXMLNODE = "FileProperties";
    public static final String EXCLUDEFROMBUILDXMLNODE = "ExcludeFromBuild";
    public static final String ENABLECODESPLITTINGXMLNODE = "EnableCodeSplitting";
    public static final String EXCLUDE_FROM_BUILD_PROPERTY = "excludeFromBuild";
    public static final String ENABLE_CODE_SPLITTING_PROPERTY = "enableCodeSplitting";

    private FileBuildPropertyData() {
    }

    public static QualifiedName getQualifiedName(String property) {
        return new QualifiedName(QUALIFIER, property);
    }

    public static void removeTITANAttributes(IFile file) {
        try {
            file.setPersistentProperty(FileBuildPropertyData.getQualifiedName(EXCLUDE_FROM_BUILD_PROPERTY), null);
            file.setPersistentProperty(FileBuildPropertyData.getQualifiedName(ENABLE_CODE_SPLITTING_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing properties of `" + file.getName() + "'"), (Throwable)e);
        }
    }

    public static boolean getPropertyValue(IFile file, String property) {
        try {
            return Boolean.parseBoolean(file.getPersistentProperty(FileBuildPropertyData.getQualifiedName(property)));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting property `" + property + "' of `" + file.getName() + "'"), (Throwable)e);
            return false;
        }
    }

    private static String getPropertyValueAsString(IFile file, String property) {
        return Boolean.toString(FileBuildPropertyData.getPropertyValue(file, property));
    }

    public static void setPropertyValue(IFile file, String property, String value) {
        FileBuildPropertyData.setPropertyValue(file, property, Boolean.parseBoolean(value));
    }

    public static void setPropertyValue(IFile file, String property, boolean value) {
        try {
            if (ENABLE_CODE_SPLITTING_PROPERTY.equals(property)) {
                if (FileBuildPropertyData.hasSupportedFileExtension(file)) {
                    file.setPersistentProperty(FileBuildPropertyData.getQualifiedName(property), value ? Boolean.TRUE.toString() : null);
                }
            } else {
                file.setPersistentProperty(FileBuildPropertyData.getQualifiedName(property), value ? Boolean.TRUE.toString() : null);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting property `" + property + "' of `" + file.getName() + "'"), (Throwable)e);
        }
    }

    public static boolean hasDefaultProperties(IFile file) {
        return !FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY) && !FileBuildPropertyData.getPropertyValue(file, ENABLE_CODE_SPLITTING_PROPERTY);
    }

    public static Element saveFileProperties(Document document, IFile file) {
        boolean enableCodeSplittingValue;
        Element root = document.createElement(FILERESOURCEXMLNODE);
        Element filePath = document.createElement(FILEPATHXMLNODE);
        filePath.appendChild(document.createTextNode(file.getProjectRelativePath().toPortableString()));
        root.appendChild(filePath);
        Element fileProperties = document.createElement(FILEPROPERTIESXMLNODE);
        boolean excludeFromBuildValue = FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY);
        if (excludeFromBuildValue) {
            Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
            excludeFromBuild.appendChild(document.createTextNode(Boolean.TRUE.toString()));
            fileProperties.appendChild(excludeFromBuild);
        }
        if ((enableCodeSplittingValue = FileBuildPropertyData.getPropertyValue(file, ENABLE_CODE_SPLITTING_PROPERTY)) && FileBuildPropertyData.hasSupportedFileExtension(file)) {
            Element enableCodeSplitting = document.createElement(ENABLECODESPLITTINGXMLNODE);
            enableCodeSplitting.appendChild(document.createTextNode(Boolean.TRUE.toString()));
            fileProperties.appendChild(enableCodeSplitting);
        }
        root.appendChild(fileProperties);
        return root;
    }

    public static void loadFileProperties(Node node, IProject project, Set<IFile> notYetReachedFiles, Set<IResource> changedResources) {
        NodeList resourceList = node.getChildNodes();
        int filePathIndex = -1;
        int filePropertiesIndex = -1;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            String nodeName = resourceList.item(i).getNodeName();
            if (FILEPATHXMLNODE.equals(nodeName)) {
                filePathIndex = i;
                continue;
            }
            if (!FILEPROPERTIESXMLNODE.equals(nodeName)) continue;
            filePropertiesIndex = i;
        }
        if (filePathIndex == -1 || filePropertiesIndex == -1) {
            return;
        }
        String filePath = resourceList.item(filePathIndex).getTextContent();
        if (!project.exists((IPath)new Path(filePath))) {
            return;
        }
        IFile file = project.getFile(filePath);
        if (notYetReachedFiles.contains(file)) {
            notYetReachedFiles.remove(file);
        }
        NodeList fileProperties = resourceList.item(filePropertiesIndex).getChildNodes();
        String oldValue = FileBuildPropertyData.getPropertyValueAsString(file, EXCLUDE_FROM_BUILD_PROPERTY);
        String oldValue2 = FileBuildPropertyData.getPropertyValueAsString(file, ENABLE_CODE_SPLITTING_PROPERTY);
        boolean selectiveCodeSplitting = false;
        int size2 = fileProperties.getLength();
        for (int i = 0; i < size2; ++i) {
            String value;
            Node property = fileProperties.item(i);
            if (EXCLUDEFROMBUILDXMLNODE.equals(property.getNodeName())) {
                value = property.getTextContent();
                if (oldValue != null && oldValue.equals(value)) continue;
                changedResources.add((IResource)file);
                FileBuildPropertyData.setPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY, value);
                continue;
            }
            if (!ENABLECODESPLITTINGXMLNODE.equals(property.getNodeName())) continue;
            value = property.getTextContent();
            if (oldValue2 != null && oldValue2.equals(value)) continue;
            changedResources.add((IResource)file);
            FileBuildPropertyData.setPropertyValue(file, ENABLE_CODE_SPLITTING_PROPERTY, value);
            selectiveCodeSplitting = true;
        }
        if (selectiveCodeSplitting) {
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "selectiveCodeSplitting"), Boolean.TRUE.toString());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }

    public static void loadDefaultProperties(IFile file, Set<IResource> changedResources) {
        boolean oldValue = FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY);
        if (!oldValue) {
            changedResources.add((IResource)file);
            FileBuildPropertyData.setPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY, false);
        }
        if (!(oldValue = FileBuildPropertyData.getPropertyValue(file, ENABLE_CODE_SPLITTING_PROPERTY))) {
            changedResources.add((IResource)file);
            FileBuildPropertyData.setPropertyValue(file, ENABLE_CODE_SPLITTING_PROPERTY, false);
        }
    }

    public static Node copyFileProperties(Node sourceNode, Document document, IProject project, Set<String> notYetReachedFiles, boolean saveDefaultValues) {
        String filePath = null;
        boolean excludeValue = false;
        boolean splittingValue = false;
        if (sourceNode != null) {
            NodeList resourceList = sourceNode.getChildNodes();
            int filePathIndex = -1;
            int filePropertiesIndex = -1;
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String nodeName = resourceList.item(i).getNodeName();
                if (FILEPATHXMLNODE.equals(nodeName)) {
                    filePathIndex = i;
                    continue;
                }
                if (!FILEPROPERTIESXMLNODE.equals(nodeName)) continue;
                filePropertiesIndex = i;
            }
            if (filePathIndex == -1) {
                return null;
            }
            filePath = resourceList.item(filePathIndex).getTextContent();
            if (!project.exists((IPath)new Path(filePath))) {
                return null;
            }
            notYetReachedFiles.remove(filePath);
            if (filePropertiesIndex != -1) {
                NodeList fileProperties = resourceList.item(filePropertiesIndex).getChildNodes();
                int size2 = fileProperties.getLength();
                for (int i = 0; i < size2; ++i) {
                    Node property = fileProperties.item(i);
                    if (EXCLUDEFROMBUILDXMLNODE.equals(property.getNodeName())) {
                        excludeValue = Boolean.parseBoolean(property.getTextContent());
                        continue;
                    }
                    if (!ENABLECODESPLITTINGXMLNODE.equals(property.getNodeName())) continue;
                    splittingValue = Boolean.parseBoolean(property.getTextContent());
                }
            }
        }
        if (!(saveDefaultValues || excludeValue || splittingValue)) {
            return null;
        }
        Element root = document.createElement(FILERESOURCEXMLNODE);
        Element filePathNode = document.createElement(FILEPATHXMLNODE);
        filePathNode.appendChild(document.createTextNode(filePath));
        root.appendChild(filePathNode);
        Element fileProperties = document.createElement(FILEPROPERTIESXMLNODE);
        Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        excludeFromBuild.appendChild(document.createTextNode(Boolean.toString(excludeValue)));
        fileProperties.appendChild(excludeFromBuild);
        Element enableCodeSplitting = document.createElement(ENABLECODESPLITTINGXMLNODE);
        enableCodeSplitting.appendChild(document.createTextNode(Boolean.toString(splittingValue)));
        fileProperties.appendChild(enableCodeSplitting);
        root.appendChild(fileProperties);
        return root;
    }

    public static Node copyDefaultFileProperties(Document document, IFile file) {
        Element root = document.createElement(FILERESOURCEXMLNODE);
        Element filePath = document.createElement(FILEPATHXMLNODE);
        filePath.appendChild(document.createTextNode(file.getProjectRelativePath().toPortableString()));
        root.appendChild(filePath);
        Element fileProperties = document.createElement(FILEPROPERTIESXMLNODE);
        Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        excludeFromBuild.appendChild(document.createTextNode(Boolean.FALSE.toString()));
        fileProperties.appendChild(excludeFromBuild);
        if (FileBuildPropertyData.hasSupportedFileExtension(file)) {
            Element enableCodeSplitting = document.createElement(ENABLECODESPLITTINGXMLNODE);
            enableCodeSplitting.appendChild(document.createTextNode(Boolean.FALSE.toString()));
            fileProperties.appendChild(enableCodeSplitting);
        }
        root.appendChild(fileProperties);
        return root;
    }

    public static boolean hasSupportedFileExtension(IFile file) {
        for (String extension : SUPPORTED_EXTENSIONS) {
            if (!extension.equals(file.getFileExtension())) continue;
            return true;
        }
        return false;
    }
}

