/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.InternalMakefileCreationData;
import org.eclipse.titan.designer.properties.data.MakeAttributesData;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ProjectBuildPropertyData {
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.Project";
    public static final String MAKEFILESETTINGSXMLNODE = "MakefileSettings";
    public static final String LOCALBUILDSETTINGS = "LocalBuildSettings";
    public static final String ACTIVECONFIGURATION = "org.eclipse.titan.designer.activeConfiguration";
    public static final String EMPTY_STRING = "";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final String USE_TPD_NAME = "useTpdName";
    public static final String ORIG_TPD_URI = "origTpdURI";
    public static final String PROJECT_COPYRIGHT_STRING_ID = "projectCopyright";
    public static final String GENERATE_MAKEFILE_PROPERTY = "generateMakefile";
    public static final String GENERATE_INTERNAL_MAKEFILE_PROPERTY = "generateInternalMakefile";
    public static final String SYMLINKLESS_BUILD_PROPERTY = "symboliclinklessBuild";
    private static final String[] MAKEFILE_PROPERTIES = new String[]{"generateMakefile", "generateInternalMakefile", "symboliclinklessBuild"};
    private static final String[] MAKEFILE_TAGS = new String[]{"generateMakefile", "generateInternalMakefile", "symboliclinklessBuild"};
    private static final String[] MAKEFILE_DEFAULTS = new String[]{"true", "true", "true"};
    public static final String LOAD_LOCATION = "loadLocation";
    public static final String ALREADY_EXPORTED = "alreadyExported";

    private ProjectBuildPropertyData() {
    }

    public static void removeTITANAttributes(IProject project) {
        try {
            project.setPersistentProperty(new QualifiedName(QUALIFIER, GENERATE_MAKEFILE_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName(QUALIFIER, GENERATE_INTERNAL_MAKEFILE_PROPERTY), null);
            project.setPersistentProperty(new QualifiedName(QUALIFIER, SYMLINKLESS_BUILD_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing attributes of `" + project.getName() + "'"), (Throwable)e);
        }
        MakefileCreationData.removeTITANAttributes(project);
        InternalMakefileCreationData.removeTITANAttributes(project);
        MakeAttributesData.removeTITANAttributes(project);
    }

    public static Element saveMakefileSettings(Document document, IProject project) {
        Element makefileSettings = document.createElement(MAKEFILESETTINGSXMLNODE);
        for (int i = 0; i < MAKEFILE_PROPERTIES.length; ++i) {
            try {
                String temp = project.getPersistentProperty(new QualifiedName(QUALIFIER, MAKEFILE_PROPERTIES[i]));
                if (temp == null || MAKEFILE_DEFAULTS[i].equals(temp)) continue;
                Element node = document.createElement(MAKEFILE_TAGS[i]);
                node.appendChild(document.createTextNode(temp));
                makefileSettings.appendChild(node);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving property `" + MAKEFILE_PROPERTIES[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
        MakefileCreationData.saveMakefileSettings(makefileSettings, document, project);
        InternalMakefileCreationData.saveMakefileSettings(makefileSettings, document, project);
        MakeAttributesData.saveMakefileSettings(makefileSettings, document, project);
        return makefileSettings;
    }

    public static void loadMakefileSettings(Node root, IProject project, Set<IResource> changedResources) {
        int i;
        NodeList resourceList = root.getChildNodes();
        changedResources.add((IResource)project);
        MakefileCreationData.loadMakefileSettings(root, project);
        InternalMakefileCreationData.loadMakefileSettings(root, project);
        MakeAttributesData.loadMakefileSettings(root, project);
        String[] tempValues = new String[MAKEFILE_TAGS.length];
        System.arraycopy(MAKEFILE_DEFAULTS, 0, tempValues, 0, MAKEFILE_TAGS.length);
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            for (int j = 0; j < MAKEFILE_TAGS.length; ++j) {
                String newValue;
                if (!MAKEFILE_TAGS[j].equals(name)) continue;
                tempValues[j] = newValue = node.getTextContent();
            }
        }
        size = MAKEFILE_PROPERTIES.length;
        for (i = 0; i < size; ++i) {
            QualifiedName qualifiedName = new QualifiedName(QUALIFIER, MAKEFILE_PROPERTIES[i]);
            String newValue = tempValues[i];
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValue == null || newValue.equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValue);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading property `" + MAKEFILE_PROPERTIES[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static Element copyMakefileSettings(Node source, Document document, boolean saveDefaultValues) {
        NodeList resourceList = source.getChildNodes();
        String[] tempValues = new String[MAKEFILE_TAGS.length];
        System.arraycopy(MAKEFILE_DEFAULTS, 0, tempValues, 0, MAKEFILE_TAGS.length);
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = resourceList.item(i);
            String name = node.getNodeName();
            for (int j = 0; j < MAKEFILE_TAGS.length; ++j) {
                String newValue;
                if (!MAKEFILE_TAGS[j].equals(name)) continue;
                tempValues[j] = newValue = node.getTextContent();
            }
        }
        Element makefileSettings = document.createElement(MAKEFILESETTINGSXMLNODE);
        for (int i = 0; i < MAKEFILE_TAGS.length; ++i) {
            String temp = tempValues[i];
            if (!saveDefaultValues && (temp == null || MAKEFILE_DEFAULTS[i].equals(temp))) continue;
            Element node = document.createElement(MAKEFILE_TAGS[i]);
            node.appendChild(document.createTextNode(temp));
            makefileSettings.appendChild(node);
        }
        MakefileCreationData.copyMakefileSettings(source, makefileSettings, document, saveDefaultValues);
        InternalMakefileCreationData.copyMakefileSettings(source, makefileSettings, document, saveDefaultValues);
        MakeAttributesData.copyMakefileSettings(source, makefileSettings, document, saveDefaultValues);
        return makefileSettings;
    }

    public static Element saveLocalBuildSettings(Document document, IProject project) {
        return MakeAttributesData.saveLocalBuildSettings(document, project);
    }

    public static void loadLocalBuildSettings(Node node, IProject project, Set<IResource> changedResources) {
        changedResources.add((IResource)project);
        MakeAttributesData.loadLocalBuildSettings(node, project);
    }

    public static Element copyLocalBuildSettings(Node source, Document document, boolean saveDefaultValues) {
        return MakeAttributesData.copyLocalBuildSettings(source, document, saveDefaultValues);
    }

    public static void setLoadLocation(IProject project, String value) {
        if (project == null || value == null) {
            return;
        }
        try {
            project.setPersistentProperty(new QualifiedName(QUALIFIER, LOAD_LOCATION), value);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting `loadLocation' for project `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void setProjectAlreadyExported(IProject project, boolean value) {
        if (project == null) {
            return;
        }
        String exported = value ? TRUE_STRING : FALSE_STRING;
        try {
            project.setPersistentProperty(new QualifiedName(QUALIFIER, ALREADY_EXPORTED), exported);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting `alreadyExported' for project `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static boolean useAutomaticMakefilegeneration(IProject project) {
        if (project == null) {
            return false;
        }
        String automaticMakefileGeneration = FALSE_STRING;
        try {
            automaticMakefileGeneration = project.getPersistentProperty(new QualifiedName(QUALIFIER, GENERATE_MAKEFILE_PROPERTY));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return TRUE_STRING.equals(automaticMakefileGeneration);
    }

    public static boolean useInternalMakefilegeneration(IProject project) {
        if (project == null) {
            return false;
        }
        String useInternalMakefileGeneration = FALSE_STRING;
        try {
            useInternalMakefileGeneration = project.getPersistentProperty(new QualifiedName(QUALIFIER, GENERATE_INTERNAL_MAKEFILE_PROPERTY));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return TRUE_STRING.equals(useInternalMakefileGeneration);
    }

    public static boolean isSymlinklessBuildSwitchedOn(IProject project) {
        if (project == null) {
            return false;
        }
        String symlinklessBuild = FALSE_STRING;
        try {
            symlinklessBuild = project.getPersistentProperty(new QualifiedName(QUALIFIER, SYMLINKLESS_BUILD_PROPERTY));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return TRUE_STRING.equals(symlinklessBuild);
    }

    public static boolean useSymbolicLinks(IProject project) {
        if (ProjectBuildPropertyData.useAutomaticMakefilegeneration(project)) {
            return !ProjectBuildPropertyData.useInternalMakefilegeneration(project) || !ProjectBuildPropertyData.isSymlinklessBuildSwitchedOn(project);
        }
        return !ProjectBuildPropertyData.isSymlinklessBuildSwitchedOn(project);
    }
}

