/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectConfigurationsPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.eclipse.ui.dialogs.PropertyPage;
import org.w3c.dom.Document;

public class ProjectConfigurationsPropertyPage
extends PropertyPage {
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.Project";
    public static final String REFERENCED_CONFIGURATION_INFO = "org.eclipse.titan.designer.referecedConfigurationInfo";
    public static final String CONFIGURATION_REQUIREMENTS_NODE = "ConfigurationRequirements";
    private static final String EDITBUTTON_TEXT = "Edit...";
    private static final String[] hostTableColumnHeaders = new String[]{"Project References", "Configuration"};
    private IProject projectResource;
    private Composite pageComposite;
    private ConfigurationManagerControl configurationManager;
    private Label headLabel;
    private TableViewer hostViewer;
    private Composite remoteHostEditComposite;
    private Button editHostButton;
    private final Image[] images = new Image[]{ImageCache.getImageDescriptor("host.gif").createImage(), ImageCache.getImageDescriptor("question.gif").createImage()};
    private final ColumnLayoutData[] hostTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(40), new ColumnWeightData(60)};

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.loadProperties();
        PropertyNotificationManager.firePropertyChange((IResource)((IProject)this.getElement()));
    }

    protected Control createContents(Composite parent) {
        this.projectResource = (IProject)this.getElement();
        this.pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        this.pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.verticalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)pageCompositeGridData);
        if (TITANBuilder.isBuilderEnabled((IProject)this.getElement())) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN C++ builder enabled.");
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN C++ builder disabled.");
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.projectResource);
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectConfigurationsPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    ProjectConfigurationsPropertyPage.this.changeConfiguration(ProjectConfigurationsPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.remoteHostEditComposite = new Composite(this.pageComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.remoteHostEditComposite.setLayout((Layout)layout);
        this.remoteHostEditComposite.setLayoutData((Object)gridData);
        this.remoteHostEditComposite.setFont(parent.getFont());
        this.createHostControllersTable(this.remoteHostEditComposite);
        this.createTableButtons(this.remoteHostEditComposite);
        this.loadProperties();
        return this.pageComposite;
    }

    private void createHostControllersTable(Composite parent) {
        this.hostViewer = new TableViewer(parent, 68356);
        Table table = this.hostViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.hostViewer.getControl().setLayoutData((Object)data);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationsLabelProvider());
        this.hostViewer.setContentProvider((IContentProvider)new ConfigurationsContentProvider());
        for (int i = 0; i < hostTableColumnHeaders.length; ++i) {
            tableLayout.addColumnData(this.hostTableColumnLayouts[i]);
            TableColumn tc = new TableColumn(table, 0, i);
            tc.setResizable(true);
            tc.setMoveable(true);
            tc.setText(hostTableColumnHeaders[i]);
            tc.setImage(this.images[i]);
        }
        this.hostViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectConfigurationsPropertyPage.this.handleEditButtonSelected();
            }
        });
    }

    private void createTableButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.horizontalAlignment = 1;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)data);
        buttonComposite.setFont(parent.getFont());
        Label label = new Label(buttonComposite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        label.setLayoutData((Object)gd);
        label.setFont(buttonComposite.getFont());
        this.editHostButton = ProjectConfigurationsPropertyPage.createPushButton(buttonComposite, EDITBUTTON_TEXT, null);
        this.editHostButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProjectConfigurationsPropertyPage.this.handleEditButtonSelected();
            }
        });
    }

    public static Button createPushButton(Composite parent, String label, Image image) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (image != null) {
            button.setImage(image);
        }
        if (label != null) {
            button.setText(label);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gd);
        return button;
    }

    protected void handleEditButtonSelected() {
        IStructuredSelection sel = (IStructuredSelection)this.hostViewer.getSelection();
        ProjectConfigurationsPropertyData.ConfigurationRequirement host = (ProjectConfigurationsPropertyData.ConfigurationRequirement)sel.getFirstElement();
        if (host == null) {
            return;
        }
        ConfigurationSelectionDialog dialog = new ConfigurationSelectionDialog(this.getShell(), host.getProjectName(), host.getConfiguration());
        if (dialog.open() != 0) {
            return;
        }
        host.setConfiguration(dialog.configuration);
        this.hostViewer.refresh((Object)host, true);
    }

    private void loadProperties() {
        this.hostViewer.setInput(ProjectConfigurationsPropertyData.getConfigurationRequirements(this.projectResource));
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    public boolean performOk() {
        TableItem[] items = this.hostViewer.getTable().getItems();
        ArrayList<ProjectConfigurationsPropertyData.ConfigurationRequirement> requirements = new ArrayList<ProjectConfigurationsPropertyData.ConfigurationRequirement>();
        for (int i = 0; i < items.length; ++i) {
            ProjectConfigurationsPropertyData.ConfigurationRequirement requirement = (ProjectConfigurationsPropertyData.ConfigurationRequirement)items[i].getData();
            String configuration = requirement.getConfiguration();
            if (configuration == null || "".equals(configuration)) continue;
            requirements.add(requirement);
        }
        ProjectConfigurationsPropertyData.setConfigurationRequirements(this.projectResource, requirements);
        this.configurationManager.saveActualConfiguration();
        ProjectDocumentHandlingUtility.saveDocument(this.projectResource);
        TITANAutomaticProjectExporter.saveAllAutomatically(this.projectResource);
        return super.performOk();
    }

    public boolean performCancel() {
        this.loadProperties();
        return super.performCancel();
    }

    protected void performDefaults() {
        try {
            this.projectResource.setPersistentProperty(new QualifiedName(QUALIFIER, CONFIGURATION_REQUIREMENTS_NODE), "");
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        this.hostViewer.setInput(ProjectConfigurationsPropertyData.getConfigurationRequirements(this.projectResource));
        this.configurationManager.saveActualConfiguration();
        super.performDefaults();
    }

    class ConfigurationSelectionDialog
    extends Dialog {
        private final String projectName;
        private String configuration;
        private Combo combo;

        public ConfigurationSelectionDialog(Shell shell, String projectName, String configuration) {
            super(shell);
            this.projectName = projectName;
            this.configuration = configuration;
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Set the configuration required from project `" + this.projectName + "'");
        }

        public String getConfiguration() {
            return this.configuration;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            container.setLayout((Layout)new GridLayout(2, false));
            container.setLayoutData((Object)new GridData(1808));
            Label label = new Label(container, 0);
            label.setLayoutData((Object)new GridData(32));
            label.setText("Required configuration: ");
            label.setToolTipText("If a project is required to have a specific configuration, having a different one will be reported as a semantic error.");
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
            Document document = ProjectDocumentHandlingUtility.getDocument(project);
            List<String> availableConfigurations = ProjectFileHandler.getConfigurations(document);
            availableConfigurations.add(0, "<No requirement>");
            this.combo = new Combo(container, 8);
            for (String temp : availableConfigurations) {
                this.combo.add(temp);
            }
            if (availableConfigurations.contains(this.configuration)) {
                this.combo.select(availableConfigurations.indexOf(this.configuration));
            } else {
                this.combo.setText("<No requirement>");
            }
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ConfigurationSelectionDialog.this.combo.getSelectionIndex() == 0) {
                        ConfigurationSelectionDialog.this.configuration = "";
                    } else {
                        ConfigurationSelectionDialog.this.configuration = ConfigurationSelectionDialog.this.combo.getText();
                    }
                    super.widgetSelected(e);
                }
            });
            return container;
        }
    }

    private static class ConfigurationsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ConfigurationsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ProjectConfigurationsPropertyData.ConfigurationRequirement) {
                ProjectConfigurationsPropertyData.ConfigurationRequirement requirement = (ProjectConfigurationsPropertyData.ConfigurationRequirement)element;
                switch (columnIndex) {
                    case 0: {
                        return requirement.getProjectName();
                    }
                    case 1: {
                        String configuration = requirement.getConfiguration();
                        if (configuration != null && !"".equals(configuration)) {
                            return configuration;
                        }
                        return "<No requirement>";
                    }
                }
            }
            return null;
        }
    }

    private static class ConfigurationsContentProvider
    implements IStructuredContentProvider {
        private ConfigurationsContentProvider() {
        }

        public void dispose() {
        }

        public ProjectConfigurationsPropertyData.ConfigurationRequirement[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                ArrayList temp = (ArrayList)inputElement;
                return ((ArrayList)inputElement).toArray(new ProjectConfigurationsPropertyData.ConfigurationRequirement[temp.size()]);
            }
            return new ProjectConfigurationsPropertyData.ConfigurationRequirement[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

