/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.titan.common.logging.ErrorReporter;

public class TitanBuilderEnabled
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IProject project = ((IResource)receiver).getProject();
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IProjectDescription description = project.getDescription();
            ICommand[] buildSpec = description.getBuildSpec();
            for (int i = 0; i < buildSpec.length; ++i) {
                String builderName = buildSpec[i].getBuilderName();
                if ("org.eclipse.titan.designer.core.TITANBuilder".equals(builderName) && "isTitanBuilder".equals(property)) {
                    return true;
                }
                if (!"org.eclipse.titan.designer.core.TITANJavaBuilder".equals(builderName) || !"isTitanJavaBuilder".equals(property)) continue;
                return true;
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return false;
    }
}

