/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.samples;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.GeneralConstants;
import org.eclipse.titan.designer.samples.SampleProject;

public class HelloWorldSample
extends SampleProject {
    protected static final String NEWLINE = StringUtils.lineSeparator();
    protected static final String NAME_TO_DISPLAY = "Hello World";
    protected static final String DESCRIPTION = "TTCN-3 version of \"Hello, world!\"";
    protected static final String HOSTNAME = HelloWorldSample.setHostName();
    private static final Map<String, String> SOURCE_FILE_CONTENT = new HashMap<String, String>();
    protected static final String MYEXAMPLE_TTCN = "// TTCN-3 version of \"Hello, world!\"" + NEWLINE + "module MyExample" + NEWLINE + "{" + NEWLINE + "type port PCOType message" + NEWLINE + "{" + NEWLINE + "  inout charstring;" + NEWLINE + "}" + NEWLINE + NEWLINE + "type component MTCType" + NEWLINE + "{" + NEWLINE + "  port PCOType MyPCO_PT;" + NEWLINE + "}" + NEWLINE + NEWLINE + "testcase tc_HelloW() runs on MTCType system MTCType" + NEWLINE + "{" + NEWLINE + "  map(mtc:MyPCO_PT, system:MyPCO_PT);" + NEWLINE + "  MyPCO_PT.send(\"Hello, world!\");" + NEWLINE + "  setverdict(pass);" + NEWLINE + "}" + NEWLINE + NEWLINE + "testcase tc_HelloW2() runs on MTCType system MTCType" + NEWLINE + "{" + NEWLINE + "  timer TL_T := 15.0;" + NEWLINE + "  map(mtc:MyPCO_PT, system:MyPCO_PT);" + NEWLINE + "  MyPCO_PT.send(\"Hello, world!\");" + NEWLINE + "  TL_T.start;" + NEWLINE + "  alt {" + NEWLINE + "    [] MyPCO_PT.receive(\"Hello, TTCN-3!\") { TL_T.stop; setverdict(pass); }" + NEWLINE + "    [] TL_T.timeout { setverdict(inconc); }" + NEWLINE + "    [] MyPCO_PT.receive { TL_T.stop; setverdict(fail); }" + NEWLINE + "  }" + NEWLINE + "}" + NEWLINE + NEWLINE + "control" + NEWLINE + "{" + NEWLINE + "  execute(tc_HelloW());" + NEWLINE + "  execute(tc_HelloW2());" + NEWLINE + "}" + NEWLINE + "}" + NEWLINE;
    protected static final String MYEXAMPLE_CFG = "[LOGGING]" + NEWLINE + "LogFile := \"logs/MyExample-%n.log\"" + NEWLINE + "FileMask := LOG_ALL" + NEWLINE + "ConsoleMask := ERROR | TESTCASE | STATISTICS" + NEWLINE + "LogSourceInfo := Stack" + NEWLINE + NEWLINE + "[EXECUTE]" + NEWLINE + "MyExample.control" + NEWLINE + NEWLINE + "[MAIN_CONTROLLER]" + NEWLINE + "# The options herein control the behavior of MC." + NEWLINE + "LocalAddress := 127.0.0.1" + NEWLINE + "TCPPort := 6789" + NEWLINE + "KillTimer := 10.0" + NEWLINE;
    protected static final String PCOTYPE_HH = "// This Test Port skeleton header file was generated by the" + NEWLINE + "// TTCN-3 Compiler of the TTCN-3 Test Executor version " + GeneralConstants.VERSION_STRING + NEWLINE + "// for (" + System.getProperty("user.name") + "@" + HOSTNAME + ")" + NEWLINE + NEWLINE + "// " + "Copyright (c) 2000-2025 Ericsson Telecom AB" + NEWLINE + NEWLINE + "// You may modify this file. Add your attributes and prototypes of your" + NEWLINE + "// member functions here." + NEWLINE + NEWLINE + "#ifndef PCOType_HH" + NEWLINE + "#define PCOType_HH" + NEWLINE + NEWLINE + "#include \"MyExample.hh\"" + NEWLINE + NEWLINE + "namespace MyExample {" + NEWLINE + NEWLINE + "class PCOType : public PCOType_BASE {" + NEWLINE + "public:" + NEWLINE + "\tPCOType(const char *par_port_name = NULL);" + NEWLINE + "\t~PCOType();" + NEWLINE + NEWLINE + "\tvoid set_parameter(const char *parameter_name," + NEWLINE + "\t\tconst char *parameter_value);" + NEWLINE + NEWLINE + "\tvoid Event_Handler(const fd_set *read_fds," + NEWLINE + "\t\tconst fd_set *write_fds, const fd_set *error_fds," + NEWLINE + "\t\tdouble time_since_last_call);" + NEWLINE + NEWLINE + "private:" + NEWLINE + "\t/* void Handle_Fd_Event(int fd, boolean is_readable," + NEWLINE + "\t\tboolean is_writable, boolean is_error); */" + NEWLINE + "\tvoid Handle_Fd_Event_Error(int fd);" + NEWLINE + "\tvoid Handle_Fd_Event_Writable(int fd);" + NEWLINE + "\tvoid Handle_Fd_Event_Readable(int fd);" + NEWLINE + "\t/* void Handle_Timeout(double time_since_last_call); */" + NEWLINE + "protected:" + NEWLINE + "\tvoid user_map(const char *system_port);" + NEWLINE + "\tvoid user_unmap(const char *system_port);" + NEWLINE + NEWLINE + "\tvoid user_start();" + NEWLINE + "\tvoid user_stop();" + NEWLINE + NEWLINE + "\tvoid outgoing_send(const CHARSTRING& send_par);" + NEWLINE + "};" + NEWLINE + NEWLINE + "} /* end of namespace */" + NEWLINE + NEWLINE + "#endif";
    protected static final String PCOTYPE_CC = "// This Test Port skeleton source file was generated by the" + NEWLINE + "// TTCN-3 Compiler of the TTCN-3 Test Executor version " + GeneralConstants.VERSION_STRING + NEWLINE + "// for (" + System.getProperty("user.name") + "@" + HOSTNAME + ")" + NEWLINE + NEWLINE + "// " + "Copyright (c) 2000-2025 Ericsson Telecom AB" + NEWLINE + NEWLINE + "// You may modify this file. Complete the body of empty functions and" + NEWLINE + "// add your member functions here." + NEWLINE + NEWLINE + "#include \"PCOType.hh\"" + NEWLINE + "#include \"memory.h\"" + NEWLINE + NEWLINE + "#include <stdio.h>" + NEWLINE + NEWLINE + "namespace MyExample {" + NEWLINE + NEWLINE + "PCOType::PCOType(const char *par_port_name)" + NEWLINE + "\t: PCOType_BASE(par_port_name)" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "PCOType::~PCOType()" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::set_parameter(const char * /*parameter_name*/," + NEWLINE + "\tconst char * /*parameter_value*/)" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::Event_Handler(const fd_set *read_fds," + NEWLINE + "\tconst fd_set *write_fds, const fd_set *error_fds," + NEWLINE + "\tdouble time_since_last_call)" + NEWLINE + "{" + NEWLINE + "\tsize_t buf_len = 0, buf_size = 32;" + NEWLINE + "\tchar *buf = (char*)Malloc(buf_size);" + NEWLINE + "\tfor ( ; ; ) {" + NEWLINE + "\t\tint c = getc(stdin);" + NEWLINE + "\t\tif (c == EOF) {" + NEWLINE + "\t\t\tif (buf_len > 0) incoming_message(CHARSTRING(buf_len, buf));" + NEWLINE + "\t\t\tUninstall_Handler();" + NEWLINE + "\t\t\tbreak;" + NEWLINE + "\t\t} else if (c == '\\n') {" + NEWLINE + "\t\t\tincoming_message(CHARSTRING(buf_len, buf));" + NEWLINE + "\t\t\tbreak;" + NEWLINE + "\t\t} else {" + NEWLINE + "\t\t\tif (buf_len >= buf_size) {" + NEWLINE + "\t\t\t\tbuf_size *= 2;" + NEWLINE + "\t\t\t\tbuf = (char*)Realloc(buf, buf_size);" + NEWLINE + "\t\t\t}" + NEWLINE + "\t\t\tbuf[buf_len++] = c;" + NEWLINE + "\t\t}" + NEWLINE + "\t}" + NEWLINE + "\tFree(buf);" + NEWLINE + "}" + NEWLINE + NEWLINE + "/*void PCOType::Handle_Fd_Event(int fd, boolean is_readable," + NEWLINE + "\tboolean is_writable, boolean is_error) {}*/" + NEWLINE + NEWLINE + "void PCOType::Handle_Fd_Event_Error(int /*fd*/)" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::Handle_Fd_Event_Writable(int /*fd*/)" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::Handle_Fd_Event_Readable(int /*fd*/)" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "/*void PCOType::Handle_Timeout(double time_since_last_call) {}*/" + NEWLINE + NEWLINE + "void PCOType::user_map(const char *system_port)" + NEWLINE + "{" + NEWLINE + "\tfd_set readfds;" + NEWLINE + "\tFD_ZERO(&readfds);" + NEWLINE + "\tFD_SET(fileno(stdin), &readfds);" + NEWLINE + "\tInstall_Handler(&readfds, NULL, NULL, 0.0);" + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::user_unmap(const char *system_port)" + NEWLINE + "{" + NEWLINE + "\tUninstall_Handler();" + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::user_start()" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::user_stop()" + NEWLINE + "{" + NEWLINE + NEWLINE + "}" + NEWLINE + NEWLINE + "void PCOType::outgoing_send(const CHARSTRING& send_par)" + NEWLINE + "{" + NEWLINE + "\tputs((const char*)send_par);" + NEWLINE + "\tfflush(stdout);" + NEWLINE + "}" + NEWLINE + NEWLINE + "} /* end of namespace */" + NEWLINE;

    private static String setHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }

    @Override
    public Map<String, String> getSourceFileContent() {
        return SOURCE_FILE_CONTENT;
    }

    @Override
    public String getName() {
        return NAME_TO_DISPLAY;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected void configure(IProject project) {
        String trueString = "true";
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateMakefile"), "true");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateInternalMakefile"), "true");
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "symboliclinklessBuild"), "true");
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while setting project property", (Throwable)e);
        }
    }

    static {
        SOURCE_FILE_CONTENT.put("MyExample.ttcn", MYEXAMPLE_TTCN);
        SOURCE_FILE_CONTENT.put("MyExample.cfg", MYEXAMPLE_CFG);
        SOURCE_FILE_CONTENT.put("PCOType.hh", PCOTYPE_HH);
        SOURCE_FILE_CONTENT.put("PCOType.cc", PCOTYPE_CC);
    }
}

