/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.core.TITANJavaBuilder;
import org.eclipse.titan.designer.wizards.projectFormat.TITANProjectExportMainPage;
import org.eclipse.titan.designer.wizards.projectFormat.TITANProjectExportOptionsPage;
import org.eclipse.titan.designer.wizards.projectFormat.TITANProjectExporter;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class TITANProjectExportWizard
extends Wizard
implements IExportWizard {
    private static final String NEWPROJECT_WINDOWTITLE = "Export TITAN Project to a TITAN Project descriptor file";
    private static final String NEWPROJECT_TITLE = "Create a TITAN Project Descriptor File";
    private static final String NEWPROJECT_DESCRIPTION = "Create a TITAN Project Descriptor (tpd) file in the workspace or in an external location";
    private static final String TITAN_JAVA_PROJECT_ERROR_MESSAGE = "TPD export of Titan Java projects are not supported!";
    private IStructuredSelection selection;
    private IProject project = null;
    private String projectFile;
    private TITANProjectExportMainPage mainPage;
    private TITANProjectExportOptionsPage optionsPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List selectionList;
        this.selection = selection;
        if (selection != null && selection.size() == 1 && (selectionList = selection.toList()).get(0) instanceof IProject) {
            this.project = (IProject)selectionList.get(0);
        }
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new TITANProjectExportMainPage(NEWPROJECT_WINDOWTITLE, this.selection);
        this.mainPage.setTitle(NEWPROJECT_TITLE);
        this.mainPage.setDescription(NEWPROJECT_DESCRIPTION);
        this.addPage((IWizardPage)this.mainPage);
        boolean useTpdName = false;
        try {
            useTpdName = this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useTpdName")) != null;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.optionsPage = new TITANProjectExportOptionsPage(useTpdName);
        this.addPage((IWizardPage)this.optionsPage);
    }

    public boolean canFinish() {
        if (this.project == null || TITANJavaBuilder.isBuilderEnabled(this.project)) {
            this.mainPage.setErrorMessage(TITAN_JAVA_PROJECT_ERROR_MESSAGE);
            this.optionsPage.setErrorMessage(TITAN_JAVA_PROJECT_ERROR_MESSAGE);
            return false;
        }
        for (IWizardPage page : this.getPages()) {
            if (page.isPageComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        if (this.project == null) {
            ErrorReporter.logError((String)"Trying to use the project information export wizard, without having selected a project to work on");
            return false;
        }
        this.projectFile = this.mainPage.getProjectFilePath();
        if (this.projectFile == null || this.projectFile.length() == 0) {
            ErrorReporter.logError((String)"Invalid target tpd file name. Use the Browse button to get a valid file path");
            return false;
        }
        URI projectFileURI = TITANPathUtilities.resolvePathURI((String)this.projectFile, (String)this.project.getLocation().toOSString());
        IPath projectFilePath = URIUtil.toPath((URI)projectFileURI);
        if (projectFilePath == null) {
            ErrorReporter.logError((String)"Invalid target tpd file name. Use the Browse button to get a valid file path");
            return false;
        }
        this.projectFile = projectFilePath.toString();
        TITANProjectExporter exporter = new TITANProjectExporter(this.project, this.projectFile);
        exporter.setIsExcludedWorkingDirectoryContents(this.optionsPage.isExcludedWorkingDirectoryContents());
        exporter.setIsExcludedDotResources(this.optionsPage.isExcludedDotResources());
        exporter.setExcludeLinkedContents(this.optionsPage.isExcludeLinkedContents());
        exporter.setSaveDefaultValues(this.optionsPage.isSaveDefaultValues());
        exporter.setPackAllProjectsIntoOne(this.optionsPage.isPackAllProjectsIntoOne());
        exporter.setUseTpdNameAttribute(this.optionsPage.isUseTpdNameAttribute());
        return exporter.saveAll();
    }

    public static final class ExportResourceVisitor
    implements IResourceVisitor {
        private static final String DOT = ".";
        private final IContainer[] workingDirectories;
        private final boolean excludeWorkingdirectoryContents;
        private final boolean excludeDotResources;
        private final boolean excludeLinkedContents;
        private final Map<String, IFolder> visitedFolders = new TreeMap<String, IFolder>();
        private final Map<String, IFile> visitedFiles = new TreeMap<String, IFile>();

        public ExportResourceVisitor(IContainer[] workingDirectories, boolean excludeWorkingdirectoryContents, boolean excludeDotResources, boolean excludeLinkedContents) {
            this.workingDirectories = workingDirectories;
            this.excludeWorkingdirectoryContents = excludeWorkingdirectoryContents;
            this.excludeDotResources = excludeDotResources;
            this.excludeLinkedContents = excludeLinkedContents;
        }

        public Map<String, IFile> getFiles() {
            return this.visitedFiles;
        }

        public Map<String, IFolder> getFolders() {
            return this.visitedFolders;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource == null) {
                return false;
            }
            String resourcename = resource.getName();
            if (resourcename == null) {
                return false;
            }
            if (this.excludeDotResources && resourcename.startsWith(DOT)) {
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    this.visitedFiles.put(resource.getProjectRelativePath().toPortableString(), (IFile)resource);
                    break;
                }
                case 2: {
                    if (this.excludeWorkingdirectoryContents) {
                        for (IContainer workingDirectory : this.workingDirectories) {
                            if (!workingDirectory.equals(resource)) continue;
                            return false;
                        }
                    }
                    this.visitedFolders.put(resource.getProjectRelativePath().toPortableString(), (IFolder)resource);
                    break;
                }
            }
            return !this.excludeLinkedContents || !resource.isLinked();
        }
    }
}

