/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Altstep;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Testcase;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.editors.ttcnppeditor.TTCNPPEditor;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class ListRunningonDefinitionsFromEditor
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        int offset;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor == null || !(editor instanceof TTCN3Editor) && !(editor instanceof TTCNPPEditor)) {
            ErrorReporter.logError((String)"The editor is not found or not a Titan TTCN-3 editor");
            return null;
        }
        IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
        IProject project = file.getProject();
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
        Module module = projectSourceParser.containedModule(file);
        ISelection selection = null;
        if (editor instanceof TTCN3Editor) {
            selection = ((TTCN3Editor)editor).getSelectionProvider().getSelection();
        }
        if (selection instanceof TextSelection && !selection.isEmpty() && !"".equals(((TextSelection)selection).getText())) {
            TextSelection tSelection = (TextSelection)selection;
            offset = tSelection.getOffset() + tSelection.getLength();
        } else {
            offset = ((TTCN3Editor)editor).getCarretOffset();
        }
        TITANConsole.println((String)"** What is running on this component** ");
        ComponentFinderVisitor visitor = new ComponentFinderVisitor(offset);
        module.accept((ASTVisitor)visitor);
        Component_Type component = visitor.component;
        if (component == null) {
            TITANConsole.println((String)"Could not find a component under the selection.");
            return null;
        }
        TITANConsole.println((String)"Running on this component :");
        FunctionFinderVisitor fun_visitor = new FunctionFinderVisitor(component);
        Set knownModuleNames = projectSourceParser.getKnownModuleNames();
        for (String moduleName : knownModuleNames) {
            Module searchModule = projectSourceParser.getModuleByName(moduleName);
            searchModule.accept((ASTVisitor)fun_visitor);
        }
        return null;
    }

    private static class FunctionFinderVisitor
    extends ASTVisitor {
        Component_Type component;

        public FunctionFinderVisitor(Component_Type component) {
            this.component = component;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Def_Function) {
                if (((Def_Function)node).getRunsOnType(CompilationTimeStamp.getBaseTimestamp()) == this.component) {
                    TITANConsole.println((String)((Def_Function)node).getFullName());
                    return 3;
                }
            } else if (node instanceof Def_Altstep) {
                if (((Def_Altstep)node).getRunsOnType(CompilationTimeStamp.getBaseTimestamp()) == this.component) {
                    TITANConsole.println((String)((Def_Altstep)node).getFullName());
                    return 3;
                }
            } else if (node instanceof Def_Testcase && ((Def_Testcase)node).getRunsOnType(CompilationTimeStamp.getBaseTimestamp()) == this.component) {
                TITANConsole.println((String)((Def_Testcase)node).getFullName());
                return 3;
            }
            return 3;
        }
    }

    private static class ComponentFinderVisitor
    extends ASTVisitor {
        Component_Type component;
        int offset;

        public ComponentFinderVisitor(int offset) {
            this.offset = offset;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Def_Type) {
                Def_Type tyepDefinition = (Def_Type)node;
                Location location = tyepDefinition.getLocation();
                Type type = tyepDefinition.getType(CompilationTimeStamp.getBaseTimestamp());
                if (location.containsOffset(this.offset)) {
                    if (type.getTypetype() != IType.Type_type.TYPE_COMPONENT) {
                        TITANConsole.println((String)("The type selected ('" + tyepDefinition.getIdentifier().getDisplayName() + "') is not a component."));
                        return 3;
                    }
                    TITANConsole.println((String)("Component : " + tyepDefinition.getIdentifier().getDisplayName()));
                    this.component = (Component_Type)type;
                    return 3;
                }
            }
            return 3;
        }
    }
}

