/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.applications.InformationExporter;
import org.eclipse.titanium.markers.export.XlsProblemExporter;

public class ExportAllCodeSmells
extends InformationExporter {
    @Override
    protected boolean checkParameters(String[] args) {
        if (args.length == 0 || args.length > 2) {
            System.out.println("This application takes as parameter the location of the resulting .XLS files and optionally the date to be inserted into the file.");
            return false;
        }
        return true;
    }

    @Override
    protected void exportInformationForProject(String[] args, IProject project, IProgressMonitor monitor) {
        XlsProblemExporter exporter = new XlsProblemExporter(project);
        try {
            Date date = args.length == 1 ? Calendar.getInstance().getTime() : new SimpleDateFormat("yyyy_MM_dd").parse(args[1]);
            exporter.exportMarkers(monitor, args[0] + project.getName() + ".xls", date);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("Error while exporting to excel " + args[0] + project.getName() + ".xls"), (Throwable)e);
        }
    }
}

