/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.titanium.graph.clustering.ModuleNameCluster;
import org.eclipse.titanium.graph.clustering.visualization.ClusterEdge;
import org.eclipse.titanium.graph.clustering.visualization.ClusterNode;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class FullModuleNameCluster
extends ModuleNameCluster {
    private Map<String, ClusterNode> mapNameNode;
    private Deque<String> stack;

    public FullModuleNameCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph) {
        super(graph);
    }

    @Override
    public void createGraph() {
        this.mapNameNode = new HashMap<String, ClusterNode>();
        this.clusterGraph = new DirectedSparseGraph();
        this.stack = new LinkedList<String>();
        ClusterNode root = new ClusterNode("/", (Set)this.mapNameCluster.get("/"));
        this.clusterGraph.addVertex((Object)root);
        this.mapNameNode.put("/", root);
        this.traverseListOfNames();
    }

    private void traverseListOfNames() {
        this.knownNames.remove("/");
        ArrayList sortedNames = new ArrayList(this.knownNames);
        Collections.sort(sortedNames);
        for (String name : sortedNames) {
            this.check(name);
        }
    }

    protected void check(String name) {
        while (!this.stack.isEmpty()) {
            String prev = this.stack.peek();
            if (name.startsWith(prev)) {
                this.addEdge(prev, name);
                this.stack.push(name);
                break;
            }
            this.stack.pop();
        }
        if (this.stack.isEmpty()) {
            this.addEdge("/", name);
            this.stack.push(name);
        }
    }

    private void addEdge(String prev, String next) {
        ClusterNode parent = this.mapNameNode.get(prev);
        ClusterNode child = new ClusterNode(next, (Set)this.mapNameCluster.get(next));
        this.clusterGraph.addVertex((Object)child);
        this.mapNameNode.put(next, child);
        ClusterEdge ce = new ClusterEdge(prev + "-" + next, 1);
        this.clusterGraph.addEdge((Object)ce, (Object)parent, (Object)child);
    }
}

