/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.spotters.implementation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.values.Array_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Bitstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Hexstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Octetstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SequenceOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.SetOf_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.RotateLeftExpression;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.RotateRightExpression;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titanium.markers.spotters.BaseCodeSmellSpotter;
import org.eclipse.titanium.markers.spotters.BaseModuleCodeSmellSpotter;
import org.eclipse.titanium.markers.types.CodeSmellType;

public class IncorrectRotate {
    private IncorrectRotate() {
        throw new AssertionError((Object)"Noninstantiable");
    }

    private static long getFirstRotateOperandLength(CompilationTimeStamp ct, Value value) {
        if (value == null) {
            return 0L;
        }
        IType.Type_type tempType = value.getExpressionReturntype(ct, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        IValue refd = value.getValueRefdLast(ct, null);
        long valueSize = 0L;
        switch (tempType) {
            case TYPE_BITSTRING: {
                if (!IValue.Value_type.BITSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                valueSize = ((Bitstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_HEXSTRING: {
                if (!IValue.Value_type.HEXSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                valueSize = ((Hexstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_OCTETSTRING: {
                if (!IValue.Value_type.OCTETSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                valueSize = ((Octetstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_CHARSTRING: {
                if (!IValue.Value_type.CHARSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                valueSize = ((Charstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_UCHARSTRING: {
                if (!IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)refd.getValuetype())) break;
                valueSize = ((UniversalCharstring_Value)refd).getValueLength();
                break;
            }
            case TYPE_SET_OF: {
                if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)value.getValuetype())) {
                    valueSize = ((SequenceOf_Value)value).getNofComponents();
                    break;
                }
                if (!IValue.Value_type.SETOF_VALUE.equals((Object)value.getValuetype())) break;
                valueSize = ((SetOf_Value)value).getNofComponents();
                break;
            }
            case TYPE_SEQUENCE_OF: {
                if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)value.getValuetype())) {
                    valueSize = ((SequenceOf_Value)value).getNofComponents();
                    break;
                }
                if (!IValue.Value_type.SETOF_VALUE.equals((Object)value.getValuetype())) break;
                valueSize = ((SetOf_Value)value).getNofComponents();
                break;
            }
            case TYPE_ARRAY: {
                if (IValue.Value_type.SEQUENCEOF_VALUE.equals((Object)value.getValuetype())) {
                    valueSize = ((SequenceOf_Value)value).getNofComponents();
                }
                if (!IValue.Value_type.ARRAY_VALUE.equals((Object)value.getValuetype())) break;
                valueSize = ((Array_Value)value).getNofComponents();
                break;
            }
        }
        return valueSize;
    }

    public static class RotateRight
    extends RotationChecker {
        public RotateRight() {
            super(CodeSmellType.INCORRECT_SHIFT_ROTATE_SIZE, "right");
        }

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof RotateRightExpression)) {
                return;
            }
            RotateRightExpression s = (RotateRightExpression)node;
            Value value1 = s.getValue1();
            Value value2 = s.getValue2();
            this.checkRotationOperands(problems, s.getLocation(), value1, value2);
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(RotateRightExpression.class);
            return ret;
        }
    }

    public static class RotateLeft
    extends RotationChecker {
        public RotateLeft() {
            super(CodeSmellType.INCORRECT_SHIFT_ROTATE_SIZE, "left");
        }

        @Override
        public void process(IVisitableNode node, BaseCodeSmellSpotter.Problems problems) {
            if (!(node instanceof RotateLeftExpression)) {
                return;
            }
            RotateLeftExpression s = (RotateLeftExpression)node;
            Value value1 = s.getValue1();
            Value value2 = s.getValue2();
            this.checkRotationOperands(problems, s.getLocation(), value1, value2);
        }

        @Override
        public List<Class<? extends IVisitableNode>> getStartNode() {
            ArrayList<Class<? extends IVisitableNode>> ret = new ArrayList<Class<? extends IVisitableNode>>(1);
            ret.add(RotateLeftExpression.class);
            return ret;
        }
    }

    private static abstract class RotationChecker
    extends BaseModuleCodeSmellSpotter {
        private static final String EFFECTLESSROTATION = "Rotating will not change the value";
        private static final String NEGATIVEROTATEPROBLEM = "Rotating to the {1} should be used instead of rotating to the {0} with a negative value";
        private static final String ZEROROTATEPROBLEM = "Rotating to the {0} with 0 will not change the original value";
        private static final String TOOBIGROTATEPROBLEM = "Rotating a {1} long value to the {0} with {2} will have the same effect as rotating by {3}";
        private final String actualRotation;

        private RotationChecker(CodeSmellType type, String actualRotation) {
            super(type);
            this.actualRotation = actualRotation;
        }

        protected void checkRotationOperands(BaseCodeSmellSpotter.Problems problems, Location location, Value value1, Value value2) {
            if (value1 == null || value2 == null) {
                return;
            }
            CompilationTimeStamp ct = CompilationTimeStamp.getBaseTimestamp();
            IType.Type_type tempType2 = value2.getExpressionReturntype(ct, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (IType.Type_type.TYPE_INTEGER != tempType2) {
                return;
            }
            IValue tempValue = value2.getValueRefdLast(ct, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            if (!IValue.Value_type.INTEGER_VALUE.equals((Object)tempValue.getValuetype())) {
                return;
            }
            long rotationSize = ((Integer_Value)tempValue).getValue();
            long valueSize = IncorrectRotate.getFirstRotateOperandLength(ct, value1);
            if (!value1.isUnfoldable(ct)) {
                if (valueSize == 0L || valueSize == 1L) {
                    problems.report(location, EFFECTLESSROTATION);
                } else if (rotationSize < 0L) {
                    problems.report(location, MessageFormat.format(NEGATIVEROTATEPROBLEM, this.actualRotation, "left".equals(this.actualRotation) ? "right" : this.actualRotation));
                } else if (rotationSize == 0L) {
                    problems.report(location, MessageFormat.format(ZEROROTATEPROBLEM, this.actualRotation));
                } else if (rotationSize > valueSize) {
                    String msg = MessageFormat.format(TOOBIGROTATEPROBLEM, this.actualRotation, valueSize, rotationSize, rotationSize % valueSize);
                    problems.report(location, msg);
                }
            }
        }
    }
}

