/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.utils;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.titanium.Activator;
import org.eclipse.titanium.markers.types.CodeSmellType;
import org.eclipse.titanium.markers.utils.Analyzer;
import org.eclipse.titanium.markers.utils.AnalyzerBuilder;

public final class AnalyzerCache {
    private static final AtomicReference<Analyzer> PREFERENCE_BASED = new AtomicReference();
    private static final AtomicReference<Analyzer> ALL_BASED = new AtomicReference();

    private AnalyzerCache() {
    }

    public static Analyzer withPreference() {
        return PREFERENCE_BASED.get();
    }

    public static Analyzer withAll() {
        return ALL_BASED.get();
    }

    private static Analyzer buildAllBased() {
        AnalyzerBuilder allBasedBuilder = Analyzer.builder();
        for (CodeSmellType type : CodeSmellType.values()) {
            allBasedBuilder.addProblem(type);
        }
        return allBasedBuilder.build();
    }

    static {
        PREFERENCE_BASED.set(Analyzer.builder().adaptPreferences().build());
        ALL_BASED.set(AnalyzerCache.buildAllBased());
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().startsWith("CODE_SMELL.")) {
                    PREFERENCE_BASED.set(Analyzer.builder().adaptPreferences().build());
                    ALL_BASED.set(AnalyzerCache.buildAllBased());
                }
            }
        });
    }
}

