/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.tl.validation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.trace4cps.tl.FormulaHelper;
import org.eclipse.trace4cps.tl.etl.Check;
import org.eclipse.trace4cps.tl.etl.Def;
import org.eclipse.trace4cps.tl.etl.EtlModel;
import org.eclipse.trace4cps.tl.etl.EtlPackage;
import org.eclipse.trace4cps.tl.etl.IdString;
import org.eclipse.trace4cps.tl.etl.IntervalNN;
import org.eclipse.trace4cps.tl.etl.IntervalNS;
import org.eclipse.trace4cps.tl.etl.IntervalSN;
import org.eclipse.trace4cps.tl.etl.IntervalSS;
import org.eclipse.trace4cps.tl.etl.ReferenceFormula;
import org.eclipse.trace4cps.tl.etl.TopLevelModelElement;
import org.eclipse.trace4cps.tl.etl.UntilFormula;
import org.eclipse.trace4cps.tl.etl.UntilUntimedFormula;
import org.eclipse.trace4cps.tl.validation.AbstractEtlValidator;
import org.eclipse.trace4cps.tl.validation.CycleDetector;
import org.eclipse.xtext.validation.CheckType;

public class EtlValidator
extends AbstractEtlValidator {
    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void infoSTLmixFormulas(Check c) {
        if (FormulaHelper.getFormulaType(c.getFormula()) == FormulaHelper.FormulaType.MIXED) {
            this.info("Mixed formula: be aware of sampling semantics", (EStructuralFeature)EtlPackage.Literals.TOP_LEVEL_MODEL_ELEMENT__NAME);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void infoSTLgeneralUntilFormulas(UntilFormula f) {
        boolean rightIsSTL;
        boolean leftIsSTL = FormulaHelper.getFormulaType(f.getLeft()) == FormulaHelper.FormulaType.STL;
        boolean bl = rightIsSTL = FormulaHelper.getFormulaType(f.getRight()) == FormulaHelper.FormulaType.STL;
        if (leftIsSTL && rightIsSTL) {
            this.info("General until not supported for STL: reverting to sampling semantics", (EStructuralFeature)EtlPackage.Literals.UNTIL_FORMULA__LEFT);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void infoSTLgeneralUntilFormulas2(UntilUntimedFormula f) {
        boolean rightIsSTL;
        boolean leftIsSTL = FormulaHelper.getFormulaType(f.getLeft()) == FormulaHelper.FormulaType.STL;
        boolean bl = rightIsSTL = FormulaHelper.getFormulaType(f.getRight()) == FormulaHelper.FormulaType.STL;
        if (leftIsSTL && rightIsSTL) {
            this.info("General until not supported for STL: reverting to sampling semantics", (EStructuralFeature)EtlPackage.Literals.UNTIL_UNTIMED_FORMULA__LEFT);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkUniqueTopLevelIDs(TopLevelModelElement e) {
        EtlModel m = (EtlModel)e.eContainer();
        for (TopLevelModelElement e2 : m.getElements()) {
            if (e.equals(e2) || !e.getName().equals(e2.getName())) continue;
            this.error("Duplicate identifier", (EStructuralFeature)EtlPackage.Literals.TOP_LEVEL_MODEL_ELEMENT__NAME);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkParamDefUsesParameter(Def d) {
        String param = d.getParam();
        if (param != null && !this.paramUsed(param, d)) {
            this.error("Parameter " + param + " is not used", (EStructuralFeature)EtlPackage.Literals.DEF__PARAM);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkParamCheckUsesParameter(Check c) {
        String param = c.getVar();
        if (param != null && !this.paramUsed(param, c)) {
            this.error("Variable " + param + " is not used", (EStructuralFeature)EtlPackage.Literals.CHECK__VAR);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkParameterDeclared(IdString id) {
        String param = id.getId();
        if (param != null && !this.paramDeclared(param, id)) {
            this.error("Parameter " + param + " is not declared", (EStructuralFeature)EtlPackage.Literals.ID_STRING__ID);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkParameterDeclared(ReferenceFormula ref) {
        String param = ref.getParam();
        if (param != null && !this.paramDeclared(param, ref)) {
            this.error("Parameter " + param + " is not declared", (EStructuralFeature)EtlPackage.Literals.REFERENCE_FORMULA__PARAM);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkCycles(EtlModel model) {
        CycleDetector det = new CycleDetector();
        HashMap<String, Def> map = new HashMap<String, Def>();
        TreeIterator it = model.eAllContents();
        while (it.hasNext()) {
            ReferenceFormula ref;
            Def src;
            EObject o = (EObject)it.next();
            if (!(o instanceof ReferenceFormula) || (src = FormulaHelper.findContainer(ref = (ReferenceFormula)o, Def.class)) == null) continue;
            det.addEdge(src.getName(), ref.getDef().getName());
            map.put(src.getName(), src);
            map.put(ref.getDef().getName(), ref.getDef());
        }
        if (det.hasCycle()) {
            for (Map.Entry e : map.entrySet()) {
                this.error("Cycle in definitions", (EObject)e.getValue(), (EStructuralFeature)EtlPackage.Literals.TOP_LEVEL_MODEL_ELEMENT__NAME);
            }
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkNonEmptyIntervalSS(IntervalSS i) {
        if (i.getLb() < 0.0) {
            this.error("Lower bound must be at least 0", (EStructuralFeature)EtlPackage.Literals.INTERVAL_SS__LB);
        }
        if (i.getInfty() == null && i.getLb() >= i.getUb()) {
            this.error("Upper bound must be larger than lower bound", (EStructuralFeature)EtlPackage.Literals.INTERVAL_SS__UB);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkNonEmptyIntervalSN(IntervalSN i) {
        if (i.getLb() < 0.0) {
            this.error("Lower bound must be at least 0", (EStructuralFeature)EtlPackage.Literals.INTERVAL_SN__LB);
        }
        if (i.getLb() >= i.getUb()) {
            this.error("Upper bound must be larger than lower bound", (EStructuralFeature)EtlPackage.Literals.INTERVAL_SN__UB);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkNonEmptyIntervalNS(IntervalNS i) {
        if (i.getLb() < 0.0) {
            this.error("Lower bound must be at least 0", (EStructuralFeature)EtlPackage.Literals.INTERVAL_NS__LB);
        }
        if (i.getInfty() == null && i.getLb() >= i.getUb()) {
            this.error("Upper bound must be larger than lower bound", (EStructuralFeature)EtlPackage.Literals.INTERVAL_NS__UB);
        }
    }

    @org.eclipse.xtext.validation.Check(value=CheckType.FAST)
    public void checkNonEmptyIntervalNN(IntervalNN i) {
        if (i.getLb() < 0.0) {
            this.error("Lower bound must be at least 0", (EStructuralFeature)EtlPackage.Literals.INTERVAL_NN__LB);
        }
        if (i.getLb() > i.getUb()) {
            this.error("Upper bound must be at least lower bound", (EStructuralFeature)EtlPackage.Literals.INTERVAL_NN__UB);
        }
    }

    private boolean paramDeclared(String param, EObject obj) {
        Def def = FormulaHelper.findContainer(obj, Def.class);
        if (def != null) {
            return def.getParam() != null && param.equals(def.getParam());
        }
        Check check = FormulaHelper.findContainer(obj, Check.class);
        if (check != null) {
            return check.getVar() != null && param.equals(check.getVar());
        }
        return false;
    }

    private boolean paramUsed(String param, EObject root) {
        TreeIterator it = EcoreUtil.getAllContents(Collections.singletonList(root));
        while (it.hasNext()) {
            ReferenceFormula r;
            IdString id;
            Object next = it.next();
            if (!(next instanceof IdString ? param.equals((id = (IdString)next).getId()) : next instanceof ReferenceFormula && param.equals((r = (ReferenceFormula)next).getParam()))) continue;
            return true;
        }
        return false;
    }
}

