/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.spi.cluster.impl.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.MultiMap;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.spi.VertxSPI;
import org.vertx.java.core.spi.cluster.AsyncMap;
import org.vertx.java.core.spi.cluster.AsyncMultiMap;
import org.vertx.java.core.spi.cluster.ClusterManager;
import org.vertx.java.core.spi.cluster.NodeListener;
import org.vertx.java.spi.cluster.impl.hazelcast.HazelcastAsyncMap;
import org.vertx.java.spi.cluster.impl.hazelcast.HazelcastAsyncMultiMap;

class HazelcastClusterManager
implements ClusterManager,
MembershipListener {
    private static final Logger log = LoggerFactory.getLogger(HazelcastClusterManager.class);
    private static final String DEFAULT_CONFIG_FILE = "default-cluster.xml";
    private static final String CONFIG_FILE = "cluster.xml";
    private final VertxSPI vertx;
    private HazelcastInstance hazelcast;
    private String nodeID;
    private NodeListener nodeListener;
    private boolean active;

    public HazelcastClusterManager(VertxSPI vertx) {
        this.vertx = vertx;
        System.setProperty("hazelcast.shutdownhook.enabled", "false");
    }

    public synchronized void join() {
        if (this.active) {
            return;
        }
        Config cfg = this.getConfig();
        if (cfg == null) {
            log.warn((Object)"Cannot find cluster configuration on classpath. Using default hazelcast configuration");
        }
        this.hazelcast = Hazelcast.newHazelcastInstance((Config)cfg);
        this.nodeID = this.hazelcast.getCluster().getLocalMember().getUuid();
        this.hazelcast.getCluster().addMembershipListener((MembershipListener)this);
        this.active = true;
    }

    public <K, V> AsyncMultiMap<K, V> getAsyncMultiMap(String name) {
        MultiMap map = this.hazelcast.getMultiMap(name);
        return new HazelcastAsyncMultiMap(this.vertx, map);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public List<String> getNodes() {
        Set members = this.hazelcast.getCluster().getMembers();
        ArrayList<String> lMembers = new ArrayList<String>();
        for (Member member : members) {
            lMembers.add(member.getUuid());
        }
        return lMembers;
    }

    public void nodeListener(NodeListener listener) {
        this.nodeListener = listener;
    }

    public <K, V> AsyncMap<K, V> getAsyncMap(String name) {
        IMap map = this.hazelcast.getMap(name);
        return new HazelcastAsyncMap(this.vertx, map);
    }

    public <K, V> Map<K, V> getSyncMap(String name) {
        IMap map = this.hazelcast.getMap(name);
        return map;
    }

    public synchronized void leave() {
        if (!this.active) {
            return;
        }
        this.hazelcast.getCluster().removeMembershipListener((MembershipListener)this);
        this.hazelcast.getLifecycleService().shutdown();
        this.active = false;
    }

    public synchronized void memberAdded(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        try {
            if (this.nodeListener != null) {
                Member member = membershipEvent.getMember();
                this.nodeListener.nodeAdded(member.getUuid());
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberAdded", t);
        }
    }

    public synchronized void memberRemoved(MembershipEvent membershipEvent) {
        if (!this.active) {
            return;
        }
        try {
            if (this.nodeListener != null) {
                Member member = membershipEvent.getMember();
                this.nodeListener.nodeLeft(member.getUuid());
            }
        }
        catch (Throwable t) {
            log.error((Object)"Failed to handle memberRemoved", t);
        }
    }

    private InputStream getConfigStream() {
        ClassLoader ctxClsLoader = Thread.currentThread().getContextClassLoader();
        InputStream is = null;
        if (ctxClsLoader != null) {
            is = ctxClsLoader.getResourceAsStream(CONFIG_FILE);
        }
        if (is == null && (is = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)) == null) {
            is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CONFIG_FILE);
        }
        return is;
    }

    protected Config getConfig() {
        Config cfg = null;
        try (InputStream is = this.getConfigStream();
             BufferedInputStream bis = new BufferedInputStream(is);){
            if (is != null) {
                cfg = new XmlConfigBuilder((InputStream)bis).build();
            }
        }
        catch (IOException ex) {
            log.error((Object)"Failed to read config", (Throwable)ex);
        }
        return cfg;
    }
}

