/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.platform.impl.resolver;

import java.net.URI;
import org.vertx.java.core.Vertx;
import org.vertx.java.platform.impl.ModuleIdentifier;
import org.vertx.java.platform.impl.resolver.RepoResolver;

public abstract class HttpRepoResolver
implements RepoResolver {
    protected final Vertx vertx;
    protected final String repoScheme;
    protected final String repoHost;
    protected final String repoUsername;
    protected final String repoPassword;
    protected final int repoPort;
    protected final String contentRoot;

    public HttpRepoResolver(Vertx vertx, String repoID) {
        this.vertx = vertx;
        try {
            URI uri = new URI(repoID);
            if (uri.getUserInfo() != null) {
                int i = uri.getUserInfo().indexOf(":");
                if (i > 0) {
                    this.repoUsername = uri.getUserInfo().substring(0, i);
                    this.repoPassword = uri.getUserInfo().substring(i + 1);
                } else {
                    this.repoUsername = null;
                    this.repoPassword = null;
                }
            } else {
                this.repoUsername = null;
                this.repoPassword = null;
            }
            this.repoScheme = uri.getScheme();
            this.repoHost = uri.getHost();
            int port = uri.getPort();
            if (port == -1) {
                port = this.repoScheme.equals("https") ? 443 : 80;
            }
            this.repoPort = port;
            this.contentRoot = uri.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(repoID + " is not a valid repository identifier");
        }
    }

    @Override
    public abstract boolean getModule(String var1, ModuleIdentifier var2);
}

