/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ThreadDumpGenerator;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadDumpGeneratorJava6
extends ThreadDumpGenerator {
    private static final String ThreadMXBean_isObjectMonitorUsageSupported = "isObjectMonitorUsageSupported";
    private static final String ThreadMXBean_isSynchronizerUsageSupported = "isSynchronizerUsageSupported";
    private static final String ThreadMXBean_dumpAllThreads = "dumpAllThreads";
    private static final String ThreadMXBean_getThreadInfo = "getThreadInfo";
    private static final String ThreadMXBean_findDeadlockedThreads = "findDeadlockedThreads";
    private static final ConcurrentMap<String, Method> methods = new ConcurrentHashMap<String, Method>();

    public ThreadDumpGeneratorJava6(ThreadMXBean bean) {
        super(bean);
    }

    @Override
    public ThreadInfo[] getAllThreads() {
        if (ThreadDumpGeneratorJava6.booleanCall(this.threadMxBean, ThreadMXBean_isObjectMonitorUsageSupported) && ThreadDumpGeneratorJava6.booleanCall(this.threadMxBean, ThreadMXBean_isSynchronizerUsageSupported)) {
            return (ThreadInfo[])ThreadDumpGeneratorJava6.parameterizedObjectCall(this.threadMxBean, ThreadMXBean_dumpAllThreads, new Class[]{Boolean.TYPE, Boolean.TYPE}, new Object[]{true, true});
        }
        return super.getAllThreads();
    }

    @Override
    public ThreadInfo[] findDeadlockedThreads() {
        if (ThreadDumpGeneratorJava6.booleanCall(this.threadMxBean, ThreadMXBean_isSynchronizerUsageSupported)) {
            long[] tids = (long[])ThreadDumpGeneratorJava6.objectCall(this.threadMxBean, ThreadMXBean_findDeadlockedThreads);
            if (tids == null || tids.length == 0) {
                return null;
            }
            return (ThreadInfo[])ThreadDumpGeneratorJava6.parameterizedObjectCall(this.threadMxBean, ThreadMXBean_getThreadInfo, new Class[]{long[].class, Boolean.TYPE, Boolean.TYPE}, new Object[]{tids, true, true});
        }
        return super.findDeadlockedThreads();
    }

    private static boolean booleanCall(Object object, String methodName) {
        Boolean result = (Boolean)ThreadDumpGeneratorJava6.objectCall(object, methodName);
        return result != null ? result : false;
    }

    private static <T> T objectCall(Object object, String methodName) {
        return ThreadDumpGeneratorJava6.parameterizedObjectCall(object, methodName, null, null);
    }

    private static <T> T parameterizedObjectCall(Object object, String methodName, Class[] types, Object[] params) {
        if (object == null) {
            throw new NullPointerException("Object is mandatory!");
        }
        try {
            Class<?> clazz = object.getClass();
            String mKey = clazz.getName() + "." + methodName;
            Method m = (Method)methods.get(mKey);
            if (m == null) {
                m = object.getClass().getMethod(methodName, types);
                m.setAccessible(true);
                Method anotherMethod = methods.putIfAbsent(mKey, m);
                if (anotherMethod != null) {
                    m = anotherMethod;
                }
            }
            return (T)m.invoke(object, params);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "While invoking method[" + methodName + "] of class[" + object.getClass().getName() + "]", e);
            return null;
        }
    }
}

