/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class OrderedExecutorFactory {
    private static final Logger log = LoggerFactory.getLogger(OrderedExecutorFactory.class);
    private final Executor parent;

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    public Executor getExecutor() {
        return new OrderedExecutor(this.parent);
    }

    private static final class OrderedExecutor
    implements Executor {
        private final LinkedList<Runnable> tasks = new LinkedList();
        private boolean running;
        private final Executor parent;
        private final Runnable runner;

        public OrderedExecutor(Executor parent) {
            this.parent = parent;
            this.runner = () -> {
                while (true) {
                    Runnable task;
                    LinkedList<Runnable> linkedList = this.tasks;
                    synchronized (linkedList) {
                        task = this.tasks.poll();
                        if (task == null) {
                            this.running = false;
                            return;
                        }
                    }
                    try {
                        task.run();
                        continue;
                    }
                    catch (Throwable t) {
                        log.error("Caught unexpected Throwable", t);
                        continue;
                    }
                    break;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            LinkedList<Runnable> linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.add(command);
                if (!this.running) {
                    this.running = true;
                    this.parent.execute(this.runner);
                }
            }
        }
    }
}

