/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.Handler;
import io.vertx.core.impl.launcher.commands.ExecUtils;
import io.vertx.core.impl.launcher.commands.FileSelector;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Watcher
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Watcher.class);
    private final long gracePeriod;
    private final Map<File, Map<File, FileInfo>> fileMap = new HashMap<File, Map<File, FileInfo>>();
    private final Set<File> filesToWatch = new HashSet<File>();
    private final long scanPeriod;
    private long lastChange = -1L;
    private final List<String> includes;
    private final File root;
    private final Handler<Handler<Void>> deploy;
    private final Handler<Handler<Void>> undeploy;
    private final String cmd;
    private volatile boolean closed;

    public Watcher(File root, List<String> includes, Handler<Handler<Void>> deploy, Handler<Handler<Void>> undeploy, String onRedeployCommand, long gracePeriod, long scanPeriod) {
        this.gracePeriod = gracePeriod;
        this.root = root;
        this.includes = includes;
        this.deploy = deploy;
        this.undeploy = undeploy;
        this.cmd = onRedeployCommand;
        this.scanPeriod = scanPeriod;
        this.addFileToWatch(root);
    }

    private void addFileToWatch(File file) {
        this.filesToWatch.add(file);
        HashMap<File, FileInfo> map = new HashMap<File, FileInfo>();
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    map.put(child, new FileInfo(child.lastModified(), child.length()));
                    if (!child.isDirectory()) continue;
                    this.addFileToWatch(child);
                }
            }
        } else {
            map.put(file, new FileInfo(file.lastModified(), file.length()));
        }
        this.fileMap.put(file, map);
    }

    private boolean changesHaveOccurred() {
        boolean changed = false;
        for (File toWatch : new HashSet<File>(this.filesToWatch)) {
            HashMap<Object, Object> newFiles = new HashMap<Object, Object>();
            if (toWatch.isDirectory()) {
                File[] files;
                File[] fileArray = files = toWatch.exists() ? toWatch.listFiles() : new File[]{};
                if (files == null) {
                    throw new IllegalStateException("Cannot scan the file system to detect file changes");
                }
                for (File file : files) {
                    newFiles.put(file, file);
                }
            } else {
                newFiles.put(toWatch, toWatch);
            }
            Map<File, FileInfo> currentFileMap = this.fileMap.get(toWatch);
            for (Map.Entry entry : new HashMap<File, FileInfo>(currentFileMap).entrySet()) {
                File currFile = (File)entry.getKey();
                FileInfo currInfo = (FileInfo)entry.getValue();
                File newFile = (File)newFiles.get(currFile);
                if (newFile == null) {
                    currentFileMap.remove(currFile);
                    if (currentFileMap.isEmpty()) {
                        this.fileMap.remove(toWatch);
                        this.filesToWatch.remove(toWatch);
                    }
                    LOGGER.trace("File: " + currFile + " has been deleted");
                    if (!this.match(currFile)) continue;
                    changed = true;
                    continue;
                }
                if (newFile.lastModified() == currInfo.lastModified && newFile.length() == currInfo.length) continue;
                currentFileMap.put(newFile, new FileInfo(newFile.lastModified(), newFile.length()));
                LOGGER.trace("File: " + currFile + " has been modified");
                if (!this.match(currFile)) continue;
                changed = true;
            }
            for (File file : newFiles.keySet()) {
                if (currentFileMap.containsKey(file)) continue;
                currentFileMap.put(file, new FileInfo(file.lastModified(), file.length()));
                if (file.isDirectory()) {
                    this.addFileToWatch(file);
                }
                LOGGER.trace("File was added: " + file);
                if (!this.match(file)) continue;
                changed = true;
            }
        }
        long now = System.currentTimeMillis();
        if (changed) {
            this.lastChange = now;
        }
        if (this.lastChange != -1L && now - this.lastChange >= this.gracePeriod) {
            this.lastChange = -1L;
            return true;
        }
        return false;
    }

    protected boolean match(File file) {
        if (!file.getAbsolutePath().startsWith(this.root.getAbsolutePath())) {
            return false;
        }
        String rel = file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
        for (String include : this.includes) {
            if (!FileSelector.matchPath(include, rel)) continue;
            return true;
        }
        return false;
    }

    public Watcher watch() {
        new Thread(this).start();
        LOGGER.info("Starting the vert.x application in redeploy mode");
        this.deploy.handle(null);
        return this;
    }

    public void close() {
        LOGGER.info("Stopping redeployment");
        this.closed = true;
        this.undeploy.handle(null);
    }

    @Override
    public void run() {
        try {
            while (!this.closed) {
                if (this.changesHaveOccurred()) {
                    this.trigger();
                }
                Thread.sleep(this.scanPeriod);
            }
        }
        catch (Throwable e) {
            LOGGER.error((Object)"An error have been encountered while watching resources - leaving the redeploy mode", e);
            this.close();
        }
    }

    private void trigger() {
        LOGGER.info("Redeploying!");
        this.undeploy.handle(v1 -> this.executeUserCommand(v2 -> this.deploy.handle(v3 -> LOGGER.info("Redeployment done"))));
    }

    private void executeUserCommand(Handler<Void> onCompletion) {
        if (this.cmd != null) {
            try {
                ArrayList<String> command = new ArrayList<String>();
                if (ExecUtils.isWindows()) {
                    ExecUtils.addArgument(command, this.cmd);
                } else {
                    ExecUtils.addArgument(command, "sh");
                    ExecUtils.addArgument(command, "-c");
                    ExecUtils.addArgument(command, this.cmd);
                }
                Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.INHERIT).redirectOutput(ProcessBuilder.Redirect.INHERIT).start();
                process.waitFor();
            }
            catch (Throwable e) {
                System.err.println("Error while executing the onRedeploy command : '" + this.cmd + "'");
                e.printStackTrace();
            }
        }
        onCompletion.handle(null);
    }

    private static final class FileInfo {
        long lastModified;
        long length;

        private FileInfo(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }
    }
}

