/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api;

import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;

/**
 * BooleanIterable is an interface which is memory-optimized for boolean primitives.
 * It is inspired by the interface RichIterable, and contains a subset of the internal iterator methods on RichIterable like collect, sum, etc.
 * The API also includes an external iterator method, which returns an BooleanIterator. BooleanIterator helps iterate over the BooleanIterable without boxing the primitives.
 * This file was automatically generated from template file primitiveIterable.stg.
 */
public interface BooleanIterable extends PrimitiveIterable
{
    BooleanIterator booleanIterator();

    boolean[] toArray();

    boolean contains(boolean value);

    boolean containsAll(boolean... source);

    boolean containsAll(BooleanIterable source);

    void forEach(BooleanProcedure procedure);

    /**
     * @since 7.0.
     */
    void each(BooleanProcedure procedure);

    BooleanIterable select(BooleanPredicate predicate);

    BooleanIterable reject(BooleanPredicate predicate);

    <V> RichIterable<V> collect(BooleanToObjectFunction<? extends V> function);

    boolean detectIfNone(BooleanPredicate predicate, boolean ifNone);

    int count(BooleanPredicate predicate);

    boolean anySatisfy(BooleanPredicate predicate);

    boolean allSatisfy(BooleanPredicate predicate);

    boolean noneSatisfy(BooleanPredicate predicate);

    MutableBooleanList toList();

    MutableBooleanSet toSet();

    MutableBooleanBag toBag();

    LazyBooleanIterable asLazy();

    <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function);
}
