/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.factory.map.primitive;

import org.eclipse.collections.api.map.primitive.ImmutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;

/**
 * A factory which creates instances of type {@link ImmutableLongObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactory.stg.
 *
 * @since 4.0.
 */
public interface ImmutableLongObjectMapFactory
{
    /**
     * @since 6.0
     */
    <V> ImmutableLongObjectMap<V> empty();

    /**
     * Same as {@link #empty()}.
     */
    <V> ImmutableLongObjectMap<V> of();

    /**
     * Same as {@link #empty()}.
     */
    <V> ImmutableLongObjectMap<V> with();

    /**
     * Same as {@link #with(long, Object)}.
     */
    <V> ImmutableLongObjectMap<V> of(long key, V value);

    <V> ImmutableLongObjectMap<V> with(long key, V value);

    /**
     * Same as {@link #withAll(LongObjectMap)}.
     */
    <V> ImmutableLongObjectMap<V> ofAll(LongObjectMap<? extends V> map);

    <V> ImmutableLongObjectMap<V> withAll(LongObjectMap<? extends V> map);
}
