/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongBytePredicate;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.map.primitive.LongByteMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongByteMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.tuple.primitive.LongBytePair;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.ByteLists;
import org.eclipse.collections.impl.iterator.ImmutableEmptyByteIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyLongIterate;

/**
 * ImmutableLongByteEmptyMap is an optimization for {@link ImmutableLongByteMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableLongByteEmptyMap implements ImmutableLongByteMap, Serializable
{
    static final ImmutableLongByteMap INSTANCE = new ImmutableLongByteEmptyMap();

    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = (byte) 0;

    private Object readResolve()
    {
        return INSTANCE;
    }

    public byte get(long key)
    {
        return EMPTY_VALUE;
    }

    public byte getIfAbsent(long key, byte ifAbsent)
    {
        return ifAbsent;
    }

    public byte getOrThrow(long key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key)
    {
        return false;
    }

    public boolean containsValue(byte value)
    {
        return false;
    }

    public void forEachValue(ByteProcedure procedure)
    {
    }

    public void forEachKey(LongProcedure procedure)
    {
    }

    public void forEachKeyValue(LongByteProcedure procedure)
    {
    }

    public LazyLongIterable keysView()
    {
        return LazyLongIterate.empty();
    }

    public RichIterable<LongBytePair> keyValuesView()
    {
        return LazyIterate.empty();
    }

    public ImmutableLongByteMap select(LongBytePredicate predicate)
    {
        return this;
    }

    public ImmutableLongByteMap reject(LongBytePredicate predicate)
    {
        return this;
    }

    public ImmutableLongByteMap toImmutable()
    {
        return this;
    }

    public ByteIterator byteIterator()
    {
        return ImmutableEmptyByteIterator.INSTANCE;
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    /**
     * @since 7.0.
     */
    public void each(ByteProcedure procedure)
    {
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public ImmutableByteCollection select(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public ImmutableByteCollection reject(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(byte... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public ImmutableLongByteMap newWithKeyValue(long key, byte value)
    {
        return new ImmutableLongByteSingletonMap(key, value);
    }

    public ImmutableLongByteMap newWithoutKey(long key)
    {
        return this;
    }

    public ImmutableLongByteMap newWithoutAllKeys(LongIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableLongSet keySet()
    {
        return UnmodifiableLongSet.of(new LongHashSet());
    }

    public MutableByteCollection values()
    {
        return UnmodifiableByteCollection.of(new ByteArrayList());
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof LongByteMap))
        {
            return false;
        }
        LongByteMap map = (LongByteMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
