/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.core.DaliPackage;
import org.eclipse.dali.core.OneToOne;
import org.eclipse.dali.core.ReferencePersistentAttributeFlavor;
import org.eclipse.dali.edit.DaliItemProviderAdapterFactory;
import org.eclipse.dali.edit.ReferencePersistentAttributeFlavorItemProvider;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.JoinColumnComposite;
import org.eclipse.dali.ui.views.ReferenceMappingComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OneToOneMappingComposite
extends ReferenceMappingComposite
implements IPersistenceComposite {
    protected Combo mappedByCombo;
    private JoinColumnComposite joinColumnComposite;
    static /* synthetic */ Class class$0;

    protected OneToOneMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
        super(parent, editingDomain, adapterFactory);
        this.initializeLayout();
    }

    protected ReferencePersistentAttributeFlavorItemProvider createReferenceMappingTypeItemProvider(DaliItemProviderAdapterFactory adapterFactory) {
        return (ReferencePersistentAttributeFlavorItemProvider)adapterFactory.createOneToOneAdapter();
    }

    private void initializeLayout() {
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        Label targetEntityLabel = new Label((Composite)this, 16384);
        targetEntityLabel.setText("Target Entity:");
        this.targetEntityCombo = this.buildTargetEntityCombo(this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.targetEntityCombo.setLayoutData((Object)gridData);
        this.buildTargetEntitySelectionButton(this);
        Label cascadeTypeLabel = new Label((Composite)this, 16384);
        cascadeTypeLabel.setText("Cascade Type:");
        this.cascadeTypeComboViewer = this.buildCascadeTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cascadeTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label fetchTypeLabel = new Label((Composite)this, 16384);
        fetchTypeLabel.setText("Fetch Type:");
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        Label mappedByLabel = new Label((Composite)this, 16384);
        mappedByLabel.setText("Mapped By:");
        this.mappedByCombo = this.buildMappedByCombo(this);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.mappedByCombo.setLayoutData((Object)gridData);
        this.joinColumnComposite = new JoinColumnComposite(this, this.editingDomain, this.adapterFactory);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.joinColumnComposite.setLayoutData(gridData);
    }

    private Combo buildMappedByCombo(Composite parent) {
        Combo combo = new Combo(parent, 2052);
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OneToOneMappingComposite.this.populating) {
                    return;
                }
                String mappedBy = ((Combo)e.getSource()).getText();
                if (mappedBy.equals("")) {
                    mappedBy = null;
                    if (OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy() == null || OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy().equals("")) {
                        return;
                    }
                }
                if (OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy() == null || !OneToOneMappingComposite.this.getOneToOneMapping().getMappedBy().equals(mappedBy)) {
                    OneToOneMappingComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)OneToOneMappingComposite.this.editingDomain, (Object)OneToOneMappingComposite.this.getOneToOneMapping(), (Object)DaliPackage.eINSTANCE.getOneToOne_MappedBy(), (Object)mappedBy));
                }
            }
        });
        return combo;
    }

    private OneToOne getOneToOneMapping() {
        return (OneToOne)this.mappingType;
    }

    public void populate(EObject model) {
        super.populate(model);
        this.populating = true;
        if (this.mappedByCombo.getItemCount() > 0) {
            this.mappedByCombo.removeAll();
        }
        if (model != null) {
            this.populateMappedByCombo();
            this.joinColumnComposite.populate((EObject)((OneToOne)this.mappingType).getJoinColumn());
        } else {
            this.joinColumnComposite.populate(null);
        }
        this.populating = false;
    }

    private void populateMappedByCombo() {
        String mappedBy = this.getOneToOneMapping().getMappedBy();
        Iterator i = this.getOneToOneMapping().possibleMappedByAttributeNames();
        while (i.hasNext()) {
            this.mappedByCombo.add((String)i.next());
        }
        if (mappedBy != null && !this.mappedByCombo.getText().equals(mappedBy)) {
            this.mappedByCombo.setText(mappedBy);
        }
    }

    protected void mappingTypeChanged(Notification notification) {
        super.mappingTypeChanged(notification);
        if (notification.getFeatureID(ReferencePersistentAttributeFlavor.class) == 7) {
            final String mappedBy = (String)notification.getNewValue();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (OneToOneMappingComposite.this.mappedByCombo.getText() == null || !OneToOneMappingComposite.this.mappedByCombo.getText().equals(mappedBy)) {
                        if (mappedBy == null) {
                            OneToOneMappingComposite.this.mappedByCombo.setText("");
                        } else {
                            OneToOneMappingComposite.this.mappedByCombo.setText(mappedBy);
                        }
                    }
                }
            });
        }
    }

    public static class OneToOneMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, DaliItemProviderAdapterFactory adapterFactory) {
            return new OneToOneMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

