/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db.ddl;

import java.util.Iterator;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistry;

public class RdbUtils {
    public static DatabaseDefinitionRegistry getDatabaseDefinitionRegistry() {
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
    }

    public static ConnectionInfo[] getRdbConnections() {
        return RDBCorePlugin.getDefault().getConnectionManager().getAllNamedConnectionInfo();
    }

    public static String getDatabaseName(String database) {
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        if (database == null || !ddr.getVersions(database).hasNext()) {
            Iterator products = ddr.getProducts();
            String product = null;
            String[] defaults = new String[]{"SQL Server", "MySql", "Oracle", "Derby", "Sybase"};
            int index = defaults.length;
            while (products.hasNext()) {
                String prodName = (String)products.next();
                if (prodName == null || prodName.trim().length() == 0) continue;
                int x = 0;
                while (x < index) {
                    if (prodName.equals(defaults[x])) {
                        index = x;
                        product = prodName;
                    }
                    ++x;
                }
            }
            if (product == null) {
                product = (String)ddr.getProducts().next();
            }
            return product;
        }
        return database;
    }

    public static String getDatabaseVersion(String database, String version) {
        DatabaseDefinitionRegistry ddr = RdbUtils.getDatabaseDefinitionRegistry();
        Iterator versions = ddr.getVersions(database);
        String newVersion = version;
        while (versions.hasNext()) {
            String tempVersion = (String)versions.next();
            if (tempVersion == null || tempVersion.trim().length() == 0) continue;
            if (tempVersion.equals(version)) {
                return version;
            }
            newVersion = tempVersion;
        }
        return newVersion;
    }
}

