/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.ITopBoundsSupport;
import org.eclipse.wb.draw2d.geometry.Dimension;

public abstract class TopBoundsSupport
implements ITopBoundsSupport {
    private static final QualifiedName KEY_DESIGN_BOUNDS = new QualifiedName("org.eclipse.wb.core", "designBounds");
    protected final AbstractComponentInfo m_component;

    public TopBoundsSupport(AbstractComponentInfo componentInfo) {
        this.m_component = componentInfo;
    }

    public abstract void apply() throws Exception;

    public abstract void setSize(int var1, int var2) throws Exception;

    public abstract boolean show() throws Exception;

    protected final IResource getUnderlyingResource() throws Exception {
        return this.m_component.getEditor().getModelUnit().getUnderlyingResource();
    }

    protected final boolean hasMethodInvocations(String[] signatures) throws Exception {
        int i = 0;
        while (i < signatures.length) {
            String signature = signatures[i];
            if (this.m_component.getMethodInvocation(signature) != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected final Dimension getResourceSize() throws Exception {
        Dimension defaultSize = this.getDefaultSize();
        int width = defaultSize.width;
        int height = defaultSize.height;
        String designBoundsString = this.getUnderlyingResource().getPersistentProperty(KEY_DESIGN_BOUNDS);
        if (designBoundsString != null) {
            String[] parts = StringUtils.split((String)designBoundsString);
            width = Integer.parseInt(parts[0]);
            height = Integer.parseInt(parts[1]);
        }
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        return new Dimension(width, height);
    }

    protected final void setResourceSize(int width, int height) throws Exception {
        String designBoundsString = String.valueOf(width) + " " + height;
        this.getUnderlyingResource().setPersistentProperty(KEY_DESIGN_BOUNDS, designBoundsString);
    }

    protected Dimension getDefaultSize() {
        IPreferenceStore preferences = this.m_component.getDescription().getToolkit().getPreferences();
        int width = preferences.getInt("general.topBoundsDefaultWidth");
        int height = preferences.getInt("general.topBoundsDefaultHeight");
        return new Dimension(width, height);
    }
}

