/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system;

import com.impossibl.postgres.datetime.DateTimeFormat;
import com.impossibl.postgres.datetime.ISODateFormat;
import com.impossibl.postgres.datetime.ISOTimeFormat;
import com.impossibl.postgres.datetime.ISOTimestampFormat;
import com.impossibl.postgres.mapper.Mapper;
import com.impossibl.postgres.mapper.PropertySetter;
import com.impossibl.postgres.protocol.BindExecCommand;
import com.impossibl.postgres.protocol.DataRow;
import com.impossibl.postgres.protocol.PrepareCommand;
import com.impossibl.postgres.protocol.Protocol;
import com.impossibl.postgres.protocol.QueryCommand;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.v30.ProtocolFactoryImpl;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.DateStyle;
import com.impossibl.postgres.system.NoticeException;
import com.impossibl.postgres.system.NotificationListener;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgProc;
import com.impossibl.postgres.system.tables.PgType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import com.impossibl.postgres.utils.Converter;
import com.impossibl.postgres.utils.Factory;
import com.impossibl.postgres.utils.Locales;
import com.impossibl.postgres.utils.Timer;
import com.impossibl.postgres.utils.guava.Strings;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class BasicContext
implements Context {
    private static final Logger logger = Logger.getLogger(BasicContext.class.getName());
    protected Registry registry;
    protected Map<String, Class<?>> targetTypeMap;
    protected Charset charset;
    protected TimeZone timeZone;
    protected DateTimeFormat dateFormatter;
    protected DateTimeFormat timeFormatter;
    protected DateTimeFormat timestampFormatter;
    protected DecimalFormat decimalFormatter;
    protected DecimalFormat currencyFormatter;
    protected Properties settings;
    protected Version serverVersion;
    protected Context.KeyData keyData;
    protected Protocol protocol;
    protected Map<NotificationKey, NotificationListener> notificationListeners;
    protected Map<String, PreparedQuery> utilQueries;

    public BasicContext(SocketAddress address, Properties settings, Map<String, Class<?>> targetTypeMap) throws IOException, NoticeException {
        this.targetTypeMap = new HashMap(targetTypeMap);
        this.settings = settings;
        this.charset = StandardCharsets.UTF_8;
        this.timeZone = TimeZone.getTimeZone("UTC");
        this.dateFormatter = new ISODateFormat();
        this.timeFormatter = new ISOTimeFormat();
        this.timestampFormatter = new ISOTimestampFormat();
        this.notificationListeners = new ConcurrentHashMap<NotificationKey, NotificationListener>();
        this.registry = new Registry(this);
        this.protocol = new ProtocolFactoryImpl().connect(address, this);
        this.utilQueries = new HashMap<String, PreparedQuery>();
    }

    protected void shutdown() {
        this.protocol.shutdown();
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Object getSetting(String name) {
        return this.settings.get(name);
    }

    @Override
    public <T> T getSetting(String name, Class<T> type) {
        return type.cast(this.settings.get(name));
    }

    public <T> T getSetting(String name, Converter<T> converter) {
        return converter.apply(this.settings.get(name));
    }

    @Override
    public <T> T getSetting(String name, T defaultValue) {
        Object val = this.settings.get(name);
        if (val == null) {
            return defaultValue;
        }
        if ((defaultValue.getClass() == Integer.TYPE || defaultValue.getClass() == Integer.class) && val instanceof String) {
            return (T)defaultValue.getClass().cast(Integer.valueOf((String)val));
        }
        if ((defaultValue.getClass() == Long.TYPE || defaultValue.getClass() == Long.class) && val instanceof String) {
            return (T)defaultValue.getClass().cast(Long.valueOf((String)val));
        }
        if ((defaultValue.getClass() == Boolean.TYPE || defaultValue.getClass() == Boolean.class) && val instanceof String) {
            return (T)defaultValue.getClass().cast(Boolean.valueOf((String)val));
        }
        return (T)defaultValue.getClass().cast(val);
    }

    @Override
    public boolean isSettingEnabled(String name) {
        Object val = this.getSetting(name);
        if (val instanceof String) {
            return ((String)val).equalsIgnoreCase("on");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    @Override
    public Class<?> lookupInstanceType(Type type) {
        Class<Object> cls = this.targetTypeMap.get(type.getName());
        if (cls == null) {
            if (type.getCategory() == Type.Category.Array) {
                return Object[].class;
            }
            cls = HashMap.class;
        }
        return cls;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Context.KeyData getKeyData() {
        return this.keyData;
    }

    @Override
    public DateTimeFormat getDateFormatter() {
        return this.dateFormatter;
    }

    @Override
    public DateTimeFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    @Override
    public DateTimeFormat getTimestampFormatter() {
        return this.timestampFormatter;
    }

    @Override
    public DecimalFormat getDecimalFormatter() {
        return this.decimalFormatter;
    }

    @Override
    public DecimalFormat getCurrencyFormatter() {
        return this.currencyFormatter;
    }

    protected void init() throws IOException, NoticeException {
        this.loadTypes();
        this.prepareRefreshTypeQueries();
        this.loadLocale();
    }

    private void loadLocale() throws IOException, NoticeException {
        for (DataRow row : this.queryResults("SELECT name, setting FROM pg_settings WHERE name IN ('lc_numeric', 'lc_time')")) {
            String localeSpec = row.getColumn(1).toString();
            switch (localeSpec.toUpperCase(Locale.US)) {
                case "C": 
                case "POSIX": {
                    localeSpec = "en_US";
                }
            }
            if (Locales.getJavaCompatibleLocale(localeSpec.split("\\.")[0]) != null) {
                localeSpec = Locales.getJavaCompatibleLocale(localeSpec);
            }
            String[] localeIds = localeSpec.split("_|\\.");
            switch (row.getColumn(0).toString()) {
                case "lc_numeric": {
                    Locale numLocale = new Locale.Builder().setLanguageTag(localeIds[0]).setRegion(localeIds[1]).build();
                    this.decimalFormatter = (DecimalFormat)DecimalFormat.getNumberInstance(numLocale);
                    this.decimalFormatter.setParseBigDecimal(true);
                    this.currencyFormatter = (DecimalFormat)NumberFormat.getCurrencyInstance(numLocale);
                    this.currencyFormatter.setParseBigDecimal(true);
                    break;
                }
                case "lc_time": {
                    Locale locale = new Locale.Builder().setLanguageTag(localeIds[0]).setRegion(localeIds[1]).build();
                }
            }
            row.release();
        }
    }

    private void loadTypes() throws IOException, NoticeException {
        Timer timer = new Timer();
        String typeSQL = PgType.INSTANCE.getSQL(this.serverVersion);
        List<PgType.Row> pgTypes = this.queryResults(typeSQL, PgType.Row.class, new Object[0]);
        String attrsSQL = PgAttribute.INSTANCE.getSQL(this.serverVersion);
        List<PgAttribute.Row> pgAttrs = this.queryResults(attrsSQL, PgAttribute.Row.class, new Object[0]);
        String procsSQL = PgProc.INSTANCE.getSQL(this.serverVersion);
        List<PgProc.Row> pgProcs = this.queryResults(procsSQL, PgProc.Row.class, new Object[0]);
        logger.fine("query time: " + timer.getLap() + "ms");
        this.registry.update(pgTypes, pgAttrs, pgProcs);
        logger.fine("load time: " + timer.getLap() + "ms");
    }

    private void prepareRefreshTypeQueries() throws IOException {
        this.prepareUtilQuery("refresh-type", PgType.INSTANCE.getSQL(this.serverVersion) + " where t.oid = $1", new String[0]);
        this.prepareUtilQuery("refresh-type-attrs", PgAttribute.INSTANCE.getSQL(this.serverVersion) + " and a.attrelid = $1", "int4");
        this.prepareUtilQuery("refresh-types", PgType.INSTANCE.getSQL(this.serverVersion) + " where t.oid > $1", "int4");
        this.prepareUtilQuery("refresh-types-attrs", PgAttribute.INSTANCE.getSQL(this.serverVersion) + " and a.attrelid = any( $1 )", "int4[]");
        this.prepareUtilQuery("refresh-reltype", PgType.INSTANCE.getSQL(this.serverVersion) + " where t.typrelid = $1", "int4");
    }

    @Override
    public void refreshType(int typeId) {
        int latestKnownTypeId = this.registry.getLatestKnownTypeId();
        if (latestKnownTypeId >= typeId) {
            this.refreshSpecificType(typeId);
        } else {
            this.refreshTypes(latestKnownTypeId);
        }
    }

    void refreshSpecificType(int typeId) {
        try {
            List<PgType.Row> pgTypes = this.queryResults("@refresh-type", PgType.Row.class, typeId);
            if (pgTypes.isEmpty()) {
                return;
            }
            List<PgAttribute.Row> pgAttrs = this.queryResults("@refresh-type-attrs", PgAttribute.Row.class, pgTypes.get(0).getRelationId());
            this.registry.update(pgTypes, pgAttrs, Collections.emptyList());
        }
        catch (NoticeException | IOException exception) {
            // empty catch block
        }
    }

    void refreshTypes(int latestTypeId) {
        try {
            List<PgType.Row> pgTypes = this.queryResults("@refresh-types", PgType.Row.class, latestTypeId);
            if (pgTypes.isEmpty()) {
                return;
            }
            Integer[] typeIds = new Integer[pgTypes.size()];
            for (int c = 0; c < pgTypes.size(); ++c) {
                typeIds[c] = pgTypes.get(c).getRelationId();
            }
            List<PgAttribute.Row> pgAttrs = this.queryResults("@refresh-types-attrs", PgAttribute.Row.class, new Object[]{typeIds});
            this.registry.update(pgTypes, pgAttrs, Collections.emptyList());
        }
        catch (NoticeException | IOException e) {
            logger.log(Level.WARNING, "Error refreshing types", e);
        }
    }

    @Override
    public void refreshRelationType(int relationId) {
        try {
            List<PgType.Row> pgTypes = this.queryResults("@refresh-reltype", PgType.Row.class, relationId);
            if (pgTypes.isEmpty()) {
                return;
            }
            List<PgAttribute.Row> pgAttrs = this.queryResults("@refresh-type-attrs", PgAttribute.Row.class, relationId);
            this.registry.update(pgTypes, pgAttrs, Collections.emptyList());
        }
        catch (NoticeException | IOException exception) {
            // empty catch block
        }
    }

    public boolean isUtilQueryPrepared(String name) {
        return this.utilQueries.containsKey(name);
    }

    public PreparedQuery prepareUtilQuery(String name, String sql, String ... parameterTypeNames) throws IOException {
        ArrayList<Type> parameterTypes = new ArrayList<Type>(parameterTypeNames.length);
        for (String parameterTypeName : parameterTypeNames) {
            parameterTypes.add(this.registry.loadType(parameterTypeName));
        }
        return this.prepareUtilQuery(name, sql, parameterTypes);
    }

    public PreparedQuery prepareUtilQuery(String name, String sql, List<Type> parameterTypes) throws IOException {
        PrepareCommand prep = this.protocol.createPrepare(name, sql, parameterTypes);
        this.protocol.execute(prep);
        if (prep.getError() != null) {
            throw new IOException("unable to prepare query: " + prep.getError().getMessage());
        }
        PreparedQuery pq = new PreparedQuery(name, prep.getDescribedParameterTypes(), prep.getDescribedResultFields());
        this.utilQueries.put(name, pq);
        return pq;
    }

    private PreparedQuery prepareQuery(String queryTxt) throws NoticeException, IOException {
        if (queryTxt.charAt(0) == '@') {
            PreparedQuery util = this.utilQueries.get(queryTxt.substring(1));
            if (util == null) {
                throw new IOException("invalid utility query");
            }
            return util;
        }
        PrepareCommand prepare = this.protocol.createPrepare(null, queryTxt, Collections.emptyList());
        this.protocol.execute(prepare);
        if (prepare.getError() != null) {
            throw new NoticeException("Error preparing query", prepare.getError());
        }
        return new PreparedQuery(null, prepare.getDescribedParameterTypes(), prepare.getDescribedResultFields());
    }

    private <T> List<T> convertResults(Class<T> rowType, List<ResultField> columnFields, List<DataRow> dataRows) throws IOException {
        List<PropertySetter> columnSetters = Mapper.buildMapping(rowType, columnFields);
        ArrayList<T> results = new ArrayList<T>(dataRows.size());
        for (int r = 0; r < dataRows.size(); ++r) {
            DataRow dataRow = dataRows.get(r);
            T row = Factory.createInstance(rowType, columnFields.size());
            for (int c = 0; c < columnSetters.size(); ++c) {
                Object columnValue = dataRow.getColumn(c);
                columnSetters.get(c).set(row, columnValue);
            }
            dataRow.release();
            results.add(row);
        }
        return results;
    }

    public <T> List<T> queryResults(String queryTxt, Class<T> rowType, Object ... params) throws IOException, NoticeException {
        QueryCommand.ResultBatch resultBatch = this.queryBatch(queryTxt, params);
        return this.convertResults(rowType, resultBatch.getFields(), resultBatch.getResults());
    }

    public List<DataRow> queryResults(String queryTxt) throws IOException, NoticeException {
        QueryCommand.ResultBatch resultBatch;
        if (queryTxt.charAt(0) == '@') {
            PreparedQuery pq = this.prepareQuery(queryTxt);
            resultBatch = this.preparedQuery(null, pq.name, Collections.emptyList(), Collections.emptyList(), pq.resultFields);
        } else {
            QueryCommand query = this.protocol.createQuery(queryTxt);
            this.protocol.execute(query);
            if (query.getError() != null) {
                throw new NoticeException("Error querying", query.getError());
            }
            List<QueryCommand.ResultBatch> resultBatches = query.getResultBatches();
            resultBatch = resultBatches.isEmpty() ? null : query.getResultBatches().get(0);
        }
        if (resultBatch == null) {
            return Collections.emptyList();
        }
        return resultBatch.getResults();
    }

    public void query(String queryTxt) throws IOException, NoticeException {
        if (queryTxt.charAt(0) == '@') {
            PreparedQuery pq = this.prepareQuery(queryTxt);
            this.preparedQuery(null, pq.name, Collections.emptyList(), Collections.emptyList(), pq.resultFields);
        }
        QueryCommand query = this.protocol.createQuery(queryTxt);
        this.protocol.execute(query);
        if (query.getError() != null) {
            throw new NoticeException("Error querying", query.getError());
        }
    }

    public String queryFirstResultString(String queryTxt) throws IOException, NoticeException {
        List<DataRow> res = this.queryResults(queryTxt);
        if (res.isEmpty()) {
            return "";
        }
        Object val = res.get(0).getColumn(0);
        for (DataRow row : res) {
            row.release();
        }
        if (val == null) {
            return "";
        }
        return val.toString();
    }

    public QueryCommand.ResultBatch queryBatch(String queryTxt, Object ... params) throws IOException, NoticeException {
        PreparedQuery pq = this.prepareQuery(queryTxt);
        return this.preparedQuery(null, pq.name, pq.parameterTypes, Arrays.asList(params), pq.resultFields);
    }

    private QueryCommand.ResultBatch preparedQuery(String portalName, String statementName, List<Type> paramTypes, List<Object> paramValues, List<ResultField> resultFields) throws IOException, NoticeException {
        BindExecCommand query = this.protocol.createBindExec(portalName, statementName, paramTypes, paramValues, resultFields);
        this.protocol.execute(query);
        if (query.getError() != null) {
            throw new NoticeException("Error executing query", query.getError());
        }
        List<QueryCommand.ResultBatch> resultBatches = query.getResultBatches();
        if (resultBatches.isEmpty()) {
            return null;
        }
        return resultBatches.get(0);
    }

    public void setKeyData(int processId, int secretKey) {
        this.keyData = new Context.KeyData(processId, secretKey);
    }

    public void updateSystemParameter(String name, String value) {
        logger.config("system parameter: " + name + "=" + value);
        switch (name) {
            case "server_version": {
                this.serverVersion = Version.parse(value);
                break;
            }
            case "DateStyle": {
                String[] parsedDateStyle = DateStyle.parse(value);
                if (parsedDateStyle == null) {
                    logger.warning("Invalid DateStyle encountered");
                    break;
                }
                this.dateFormatter = DateStyle.getDateFormatter(parsedDateStyle);
                if (this.dateFormatter == null) {
                    logger.warning("Unknown Date format, reverting to default");
                    this.dateFormatter = new ISODateFormat();
                }
                this.timeFormatter = DateStyle.getTimeFormatter(parsedDateStyle);
                if (this.timeFormatter == null) {
                    logger.warning("Unknown Time format, reverting to default");
                    this.timeFormatter = new ISOTimeFormat();
                }
                this.timestampFormatter = DateStyle.getTimestampFormatter(parsedDateStyle);
                if (this.timestampFormatter != null) break;
                logger.warning("Unknown Timestamp format, reverting to default");
                this.timestampFormatter = new ISOTimestampFormat();
                break;
            }
            case "TimeZone": {
                this.timeZone = TimeZone.getTimeZone(value);
                break;
            }
            case "integer_datetimes": {
                this.settings.put("field.datetime.format", Integer.class);
                break;
            }
            case "client_encoding": {
                this.charset = Charset.forName(value);
                break;
            }
            case "standard_conforming_strings": {
                this.settings.put("standard_conforming_strings", (Object)value.equals("on"));
                break;
            }
        }
    }

    public void addNotificationListener(String name, String channelNameFilter, NotificationListener listener) {
        name = Strings.nullToEmpty(name);
        channelNameFilter = channelNameFilter != null ? channelNameFilter : ".*";
        Pattern channelNameFilterPattern = Pattern.compile(channelNameFilter);
        NotificationKey key = new NotificationKey(name, channelNameFilterPattern);
        this.notificationListeners.put(key, listener);
    }

    public synchronized void removeNotificationListener(NotificationListener listener) {
        Iterator<Map.Entry<NotificationKey, NotificationListener>> iter = this.notificationListeners.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<NotificationKey, NotificationListener> entry = iter.next();
            NotificationListener iterListener = entry.getValue();
            if (iterListener != null && !iterListener.equals(listener)) continue;
            iter.remove();
        }
    }

    public synchronized void removeNotificationListener(String listenerName) {
        Iterator<Map.Entry<NotificationKey, NotificationListener>> iter = this.notificationListeners.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<NotificationKey, NotificationListener> entry = iter.next();
            String iterListenerName = entry.getKey().name;
            NotificationListener iterListener = entry.getValue();
            if (!iterListenerName.equals(listenerName) && iterListener != null) continue;
            iter.remove();
        }
    }

    @Override
    public synchronized void reportNotification(int processId, String channelName, String payload) {
        for (Map.Entry<NotificationKey, NotificationListener> entry : this.notificationListeners.entrySet()) {
            NotificationListener listener = entry.getValue();
            if (!entry.getKey().channelNameFilter.matcher(channelName).matches()) continue;
            listener.notification(processId, channelName, payload);
        }
    }

    @Override
    public Context unwrap() {
        return this;
    }

    private static class NotificationKey {
        private String name;
        private Pattern channelNameFilter;

        NotificationKey(String name, Pattern channelNameFilter) {
            this.name = name;
            this.channelNameFilter = channelNameFilter;
        }

        String getName() {
            return this.name;
        }

        Pattern getChannelNameFilter() {
            return this.channelNameFilter;
        }
    }

    private static class PreparedQuery {
        String name;
        List<Type> parameterTypes;
        List<ResultField> resultFields;

        PreparedQuery(String name, List<Type> parameterTypes, List<ResultField> resultFields) {
            this.name = name;
            this.parameterTypes = parameterTypes;
            this.resultFields = resultFields;
        }
    }
}

