/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.remote;

import de.undercouch.citeproc.helper.oauth.AuthenticationStore;
import de.undercouch.citeproc.remote.RemoteConnector;
import de.undercouch.citeproc.remote.RemoteConnectorAdapter;
import java.io.IOException;

public class AuthenticatedRemoteConnector
extends RemoteConnectorAdapter {
    private final AuthenticationStore store;

    public AuthenticatedRemoteConnector(RemoteConnector delegate, AuthenticationStore store) {
        super(delegate);
        this.store = store;
        String token = store.getToken();
        String secret = store.getSecret();
        if (token != null && secret != null) {
            delegate.setAccessToken(token, secret);
        }
    }

    @Override
    public void authorize(String verificationCode) throws IOException {
        super.authorize(verificationCode);
        try {
            this.store.save(this.getAccessTokenValue(), this.getAccessTokenSecret());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not store access token", e);
        }
    }

    @Override
    public void setAccessToken(String token, String secret) {
        super.setAccessToken(token, secret);
        try {
            this.store.save(token, secret);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not store access token", e);
        }
    }
}

