/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.errorconsole;

import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.core.LogEvent;
import org.jabref.gui.IconTheme;
import org.jabref.logic.util.OS;

public class LogEventViewModel {
    private LogEvent logEvent;

    public LogEventViewModel(LogEvent logEvent) {
        this.logEvent = Objects.requireNonNull(logEvent);
    }

    public String getDisplayText() {
        return this.logEvent.getMessage().getFormattedMessage();
    }

    public String getStyleClass() {
        switch (this.logEvent.getLevel().getStandardLevel()) {
            case ERROR: {
                return "exception";
            }
            case WARN: {
                return "output";
            }
        }
        return "log";
    }

    public IconTheme.JabRefIcon getIcon() {
        switch (this.logEvent.getLevel().getStandardLevel()) {
            case ERROR: {
                return IconTheme.JabRefIcon.INTEGRITY_FAIL;
            }
            case WARN: {
                return IconTheme.JabRefIcon.INTEGRITY_WARN;
            }
        }
        return IconTheme.JabRefIcon.INTEGRITY_INFO;
    }

    public Optional<String> getStackTrace() {
        return Optional.ofNullable(this.logEvent.getMessage().getThrowable()).map(Throwables::getStackTraceAsString);
    }

    public String getDetailedText() {
        return this.getDisplayText() + this.getStackTrace().map(stacktrace -> OS.NEWLINE + stacktrace).orElse("");
    }
}

