/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.maintable.MainTableDataModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.search.SearchMatcher;

class GroupingWorker {
    private final JabRefFrame frame;
    private final BasePanel panel;

    public GroupingWorker(JabRefFrame frame, BasePanel panel) {
        this.frame = frame;
        this.panel = panel;
    }

    public void run(SearchMatcher matcher) {
        for (BibEntry entry : this.panel.getDatabase().getEntries()) {
            boolean hit = matcher.isMatch(entry);
            entry.setGroupHit(hit);
        }
    }

    public void update() {
        if (Globals.prefs.getBoolean("grayOutNonHits")) {
            this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.FLOAT);
        } else {
            this.panel.getMainTable().getTableModel().updateGroupingState(MainTableDataModel.DisplayOption.FILTER);
        }
        this.panel.getMainTable().getTableModel().updateSortOrder();
        this.panel.getMainTable().getTableModel().updateGroupFilter();
        this.panel.getMainTable().scrollTo(0);
        this.frame.output(Localization.lang("Updated group selection", new String[0]) + ".");
    }
}

