/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer.fetcher;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jabref.Globals;
import org.jabref.gui.importer.fetcher.ACMPortalFetcher;
import org.jabref.gui.importer.fetcher.CiteSeerXFetcher;
import org.jabref.gui.importer.fetcher.DOAJFetcher;
import org.jabref.gui.importer.fetcher.EntryFetcher;
import org.jabref.gui.importer.fetcher.IEEEXploreFetcher;
import org.jabref.gui.importer.fetcher.INSPIREFetcher;
import org.jabref.gui.importer.fetcher.SearchBasedEntryFetcher;
import org.jabref.gui.importer.fetcher.SpringerFetcher;
import org.jabref.logic.importer.WebFetchers;
import org.jabref.logic.journals.JournalAbbreviationLoader;

public class EntryFetchers {
    private final List<EntryFetcher> entryFetchers = new LinkedList<EntryFetcher>();

    public EntryFetchers(JournalAbbreviationLoader abbreviationLoader) {
        this.entryFetchers.add(new CiteSeerXFetcher());
        this.entryFetchers.add(new IEEEXploreFetcher(abbreviationLoader));
        this.entryFetchers.add(new INSPIREFetcher());
        this.entryFetchers.add(new ACMPortalFetcher());
        this.entryFetchers.add(new DOAJFetcher());
        this.entryFetchers.add(new SpringerFetcher());
        WebFetchers.getSearchBasedFetchers(Globals.prefs.getImportFormatPreferences()).stream().map(SearchBasedEntryFetcher::new).forEach(this.entryFetchers::add);
    }

    public List<EntryFetcher> getEntryFetchers() {
        return Collections.unmodifiableList(this.entryFetchers);
    }
}

