/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.push.PushToApplication;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.metadata.MetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToVim
extends AbstractPushToApplication
implements PushToApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToVim.class);
    private final JTextField vimServer = new JTextField(30);

    @Override
    public String getApplicationName() {
        return "Vim";
    }

    @Override
    public Icon getIcon() {
        return IconTheme.getImage("vim");
    }

    @Override
    public JPanel getSettingsPanel() {
        this.vimServer.setText(Globals.prefs.get("vimServer"));
        return super.getSettingsPanel();
    }

    @Override
    public void storeSettings() {
        super.storeSettings();
        Globals.prefs.put("vimServer", this.vimServer.getText());
    }

    @Override
    protected void initSettingsPanel() {
        super.initSettingsPanel();
        this.builder.appendRows("2dlu, p", new Object[0]);
        this.builder.add(Localization.lang("Vim server name", new String[0]) + ":", new Object[0]).xy(1, 3);
        this.builder.add(this.vimServer).xy(3, 3);
        this.settings = this.builder.build();
    }

    @Override
    public void pushEntries(BibDatabase database, List<BibEntry> entries, String keys, MetaData metaData) {
        this.couldNotConnect = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.initParameters();
        this.commandPath = Globals.prefs.get(this.commandPathPreferenceKey);
        if (this.commandPath == null || this.commandPath.trim().isEmpty()) {
            this.notDefined = true;
            return;
        }
        try {
            String[] com = new String[]{this.commandPath, "--servername", Globals.prefs.get("vimServer"), "--remote-send", "<C-\\><C-N>a" + this.getCiteCommand() + "{" + keys + "}"};
            Process p = Runtime.getRuntime().exec(com);
            JabRefExecutorService.INSTANCE.executeAndWait(() -> {
                try (InputStream out = p.getErrorStream();){
                    StringBuilder sb = new StringBuilder();
                    try {
                        int c;
                        while ((c = out.read()) != -1) {
                            sb.append((char)c);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not read from stderr.", e);
                    }
                    if (!sb.toString().trim().isEmpty()) {
                        LOGGER.warn("Push to Vim error: " + sb);
                        this.couldNotConnect = true;
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("File problem.", e);
                }
            });
        }
        catch (IOException excep) {
            this.couldNotCall = true;
            LOGGER.warn("Problem pushing to Vim.", excep);
        }
    }

    @Override
    public void operationCompleted(BasePanel panel) {
        if (this.couldNotConnect) {
            JOptionPane.showMessageDialog(panel.frame(), "<HTML>" + Localization.lang("Could not connect to Vim server. Make sure that Vim is running<BR>with correct server name.", new String[0]) + "</HTML>", Localization.lang("Error", new String[0]), 0);
        } else if (this.couldNotCall) {
            JOptionPane.showMessageDialog(panel.frame(), Localization.lang("Could not run the 'vim' program.", new String[0]), Localization.lang("Error", new String[0]), 0);
        } else {
            super.operationCompleted(panel);
        }
    }

    @Override
    protected void initParameters() {
        this.commandPathPreferenceKey = "vim";
    }
}

