/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.importer.FulltextFetcher;
import org.jabref.logic.importer.fetcher.TrustLevel;
import org.jabref.logic.net.URLDownload;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.DOI;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoiResolution
implements FulltextFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoiResolution.class);

    @Override
    public Optional<URL> findFullText(BibEntry entry) throws IOException {
        String sciLink;
        Objects.requireNonNull(entry);
        Optional pdfLink = Optional.empty();
        Optional doi = entry.getField("doi").flatMap(DOI::parse);
        if (doi.isPresent() && !(sciLink = ((DOI)doi.get()).getURIAsASCIIString()).isEmpty()) {
            try {
                Connection connection = Jsoup.connect(sciLink);
                connection.userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0");
                connection.referrer("http://www.google.com");
                connection.followRedirects(true);
                connection.ignoreHttpErrors(true);
                connection.timeout(10000);
                Document html = connection.get();
                Elements elements = html.body().select("a[href]");
                ArrayList<Optional<URL>> links = new ArrayList<Optional<URL>>();
                for (Element element : elements) {
                    String href = element.attr("abs:href").toLowerCase(Locale.ENGLISH);
                    String hrefText = element.text().toLowerCase(Locale.ENGLISH);
                    if (!href.contains("pdf") && !hrefText.contains("pdf") || !new URLDownload(href).isPdf()) continue;
                    links.add(Optional.of(new URL(href)));
                }
                if (links.size() == 1) {
                    LOGGER.info("Fulltext PDF found @ " + sciLink);
                    pdfLink = (Optional)links.get(0);
                }
            }
            catch (UnsupportedMimeTypeException type) {
                if (type.getMimeType().startsWith("application/pdf")) {
                    return Optional.of(new URL(type.getUrl()));
                }
                LOGGER.warn("DoiResolution fetcher failed: ", type);
            }
            catch (IOException e) {
                LOGGER.warn("DoiResolution fetcher failed: ", e);
            }
        }
        return pdfLink;
    }

    @Override
    public TrustLevel getTrustLevel() {
        return TrustLevel.SOURCE;
    }
}

