/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.fetcher.AbstractIsbnFetcher;
import org.jabref.model.entry.BibEntry;
import org.jsoup.helper.StringUtil;

public class IsbnViaChimboriFetcher
extends AbstractIsbnFetcher {
    public IsbnViaChimboriFetcher(ImportFormatPreferences importFormatPreferences) {
        super(importFormatPreferences);
    }

    @Override
    public String getName() {
        return "ISBN (Chimbori/Amazon)";
    }

    @Override
    public URL getURLForID(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        return null;
    }

    @Override
    public Optional<BibEntry> performSearchById(String identifier) throws FetcherException {
        List<BibEntry> fetchedEntries;
        HttpResponse<String> postResponse;
        if (StringUtil.isBlank(identifier)) {
            return Optional.empty();
        }
        this.ensureThatIsbnIsValid(identifier);
        try {
            postResponse = Unirest.post("https://bibtex.chimbori.com/isbn-bibtex").field("isbn", identifier).asString();
        }
        catch (UnirestException e) {
            throw new FetcherException("Could not retrieve data from chimbori.com", e);
        }
        if (postResponse.getStatus() != 200) {
            throw new FetcherException("Error while retrieving data from chimbori.com: " + postResponse.getBody());
        }
        try {
            fetchedEntries = this.getParser().parseEntries(postResponse.getRawBody());
        }
        catch (ParseException e) {
            throw new FetcherException("An internal parser error occurred", e);
        }
        if (fetchedEntries.isEmpty()) {
            return Optional.empty();
        }
        if (fetchedEntries.size() > 1) {
            LOGGER.info("Fetcher " + this.getName() + "found more than one result for identifier " + identifier + ". We will use the first entry.");
        }
        BibEntry entry = fetchedEntries.get(0);
        entry.setField("isbn", identifier);
        this.doPostCleanup(entry);
        return Optional.of(entry);
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
    }
}

