/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.logic.integrity.AbbreviationChecker;
import org.jabref.logic.integrity.BooktitleChecker;
import org.jabref.logic.integrity.BracketChecker;
import org.jabref.logic.integrity.DOIValidityChecker;
import org.jabref.logic.integrity.DateChecker;
import org.jabref.logic.integrity.EditionChecker;
import org.jabref.logic.integrity.FieldChecker;
import org.jabref.logic.integrity.FileChecker;
import org.jabref.logic.integrity.HowPublishedChecker;
import org.jabref.logic.integrity.ISBNChecker;
import org.jabref.logic.integrity.ISSNChecker;
import org.jabref.logic.integrity.MonthChecker;
import org.jabref.logic.integrity.NoteChecker;
import org.jabref.logic.integrity.PagesChecker;
import org.jabref.logic.integrity.PersonNamesChecker;
import org.jabref.logic.integrity.TitleChecker;
import org.jabref.logic.integrity.UrlChecker;
import org.jabref.logic.integrity.ValidBibtexKeyChecker;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.logic.integrity.YearChecker;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.metadata.FileDirectoryPreferences;

public class FieldCheckers {
    private Multimap<String, ValueChecker> fieldChecker;

    public FieldCheckers(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences, JournalAbbreviationRepository abbreviationRepository, boolean enforceLegalKey) {
        this.fieldChecker = FieldCheckers.getAllMap(databaseContext, fileDirectoryPreferences, abbreviationRepository, enforceLegalKey);
    }

    private static Multimap<String, ValueChecker> getAllMap(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences, JournalAbbreviationRepository abbreviationRepository, boolean enforceLegalKey) {
        ArrayListMultimap<String, ValueChecker> fieldCheckers = ArrayListMultimap.create(50, 10);
        for (String field2 : InternalBibtexFields.getJournalNameFields()) {
            fieldCheckers.put((Object)field2, (Object)new AbbreviationChecker(abbreviationRepository));
        }
        for (String field2 : InternalBibtexFields.getBookNameFields()) {
            fieldCheckers.put((Object)field2, (Object)new AbbreviationChecker(abbreviationRepository));
        }
        for (String field2 : InternalBibtexFields.getPersonNameFields()) {
            fieldCheckers.put((Object)field2, (Object)new PersonNamesChecker(databaseContext));
        }
        fieldCheckers.put((Object)"booktitle", (Object)new BooktitleChecker());
        fieldCheckers.put((Object)"title", (Object)new BracketChecker());
        fieldCheckers.put((Object)"title", (Object)new TitleChecker(databaseContext));
        fieldCheckers.put((Object)"doi", (Object)new DOIValidityChecker());
        fieldCheckers.put((Object)"edition", (Object)new EditionChecker(databaseContext));
        fieldCheckers.put((Object)"file", (Object)new FileChecker(databaseContext, fileDirectoryPreferences));
        fieldCheckers.put((Object)"howpublished", (Object)new HowPublishedChecker(databaseContext));
        fieldCheckers.put((Object)"isbn", (Object)new ISBNChecker());
        fieldCheckers.put((Object)"issn", (Object)new ISSNChecker());
        fieldCheckers.put((Object)"month", (Object)new MonthChecker(databaseContext));
        fieldCheckers.put((Object)"monthfiled", (Object)new MonthChecker(databaseContext));
        fieldCheckers.put((Object)"note", (Object)new NoteChecker(databaseContext));
        fieldCheckers.put((Object)"pages", (Object)new PagesChecker(databaseContext));
        fieldCheckers.put((Object)"url", (Object)new UrlChecker());
        fieldCheckers.put((Object)"year", (Object)new YearChecker());
        fieldCheckers.put((Object)"key", (Object)new ValidBibtexKeyChecker(enforceLegalKey));
        if (databaseContext.isBiblatexMode()) {
            fieldCheckers.put((Object)"date", (Object)new DateChecker());
            fieldCheckers.put((Object)"urldate", (Object)new DateChecker());
            fieldCheckers.put((Object)"eventdate", (Object)new DateChecker());
            fieldCheckers.put((Object)"origdate", (Object)new DateChecker());
        }
        return fieldCheckers;
    }

    public List<FieldChecker> getAll() {
        return this.fieldChecker.entries().stream().map(pair -> new FieldChecker((String)pair.getKey(), (ValueChecker)pair.getValue())).collect(Collectors.toList());
    }

    public Collection<ValueChecker> getForField(String field2) {
        return this.fieldChecker.get(field2);
    }
}

