/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.openoffice;

import com.sun.star.awt.FontSlant;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabref.logic.layout.Layout;
import org.jabref.logic.openoffice.UndefinedParagraphFormatException;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.entry.BibEntry;

public class OOUtil {
    private static final String CHAR_STRIKEOUT = "CharStrikeout";
    private static final String CHAR_UNDERLINE = "CharUnderline";
    private static final String PARA_STYLE_NAME = "ParaStyleName";
    private static final String CHAR_CASE_MAP = "CharCaseMap";
    private static final String CHAR_POSTURE = "CharPosture";
    private static final String CHAR_WEIGHT = "CharWeight";
    private static final String CHAR_ESCAPEMENT_HEIGHT = "CharEscapementHeight";
    private static final String CHAR_ESCAPEMENT = "CharEscapement";
    private static final Pattern HTML_TAG = Pattern.compile("</?[a-z]+>");
    private static final String UNIQUEFIER_FIELD = "uniq";

    private OOUtil() {
    }

    public static void insertFullReferenceAtCurrentLocation(XText text, XTextCursor cursor, Layout layout, String parStyle, BibEntry entry, BibDatabase database, String uniquefier) throws UndefinedParagraphFormatException, UnknownPropertyException, PropertyVetoException, WrappedTargetException, IllegalArgumentException {
        Optional<String> oldUniqVal = entry.getField(UNIQUEFIER_FIELD);
        if (uniquefier == null) {
            entry.clearField(UNIQUEFIER_FIELD);
        } else {
            entry.setField(UNIQUEFIER_FIELD, uniquefier);
        }
        String formattedText = layout.doLayout(entry, database);
        if (oldUniqVal.isPresent()) {
            entry.setField(UNIQUEFIER_FIELD, oldUniqVal.get());
        } else {
            entry.clearField(UNIQUEFIER_FIELD);
        }
        OOUtil.insertOOFormattedTextAtCurrentLocation(text, cursor, formattedText, parStyle);
    }

    public static void insertOOFormattedTextAtCurrentLocation(XText text, XTextCursor cursor, String lText, String parStyle) throws UndefinedParagraphFormatException, UnknownPropertyException, PropertyVetoException, WrappedTargetException, IllegalArgumentException {
        XParagraphCursor parCursor = UnoRuntime.queryInterface(XParagraphCursor.class, (Object)cursor);
        XPropertySet props = UnoRuntime.queryInterface(XPropertySet.class, (Object)parCursor);
        try {
            props.setPropertyValue(PARA_STYLE_NAME, parStyle);
        }
        catch (IllegalArgumentException ex) {
            throw new UndefinedParagraphFormatException(parStyle);
        }
        ArrayList<Formatting> formatting = new ArrayList<Formatting>();
        int piv = 0;
        Matcher m3 = HTML_TAG.matcher(lText);
        while (m3.find()) {
            String tag;
            String currentSubstring = lText.substring(piv, m3.start());
            if (!currentSubstring.isEmpty()) {
                OOUtil.insertTextAtCurrentLocation(text, cursor, currentSubstring, formatting);
            }
            if ("<b>".equals(tag = m3.group())) {
                formatting.add(Formatting.BOLD);
            } else if ("</b>".equals(tag)) {
                formatting.remove((Object)Formatting.BOLD);
            } else if ("<i>".equals(tag) || "<em>".equals(tag)) {
                formatting.add(Formatting.ITALIC);
            } else if ("</i>".equals(tag) || "</em>".equals(tag)) {
                formatting.remove((Object)Formatting.ITALIC);
            } else if ("<tt>".equals(tag)) {
                formatting.add(Formatting.MONOSPACE);
            } else if ("</tt>".equals(tag)) {
                formatting.remove((Object)Formatting.MONOSPACE);
            } else if ("<smallcaps>".equals(tag)) {
                formatting.add(Formatting.SMALLCAPS);
            } else if ("</smallcaps>".equals(tag)) {
                formatting.remove((Object)Formatting.SMALLCAPS);
            } else if ("<sup>".equals(tag)) {
                formatting.add(Formatting.SUPERSCRIPT);
            } else if ("</sup>".equals(tag)) {
                formatting.remove((Object)Formatting.SUPERSCRIPT);
            } else if ("<sub>".equals(tag)) {
                formatting.add(Formatting.SUBSCRIPT);
            } else if ("</sub>".equals(tag)) {
                formatting.remove((Object)Formatting.SUBSCRIPT);
            } else if ("<u>".equals(tag)) {
                formatting.add(Formatting.UNDERLINE);
            } else if ("</u>".equals(tag)) {
                formatting.remove((Object)Formatting.UNDERLINE);
            } else if ("<s>".equals(tag)) {
                formatting.add(Formatting.STRIKEOUT);
            } else if ("</s>".equals(tag)) {
                formatting.remove((Object)Formatting.STRIKEOUT);
            }
            piv = m3.end();
        }
        if (piv < lText.length()) {
            OOUtil.insertTextAtCurrentLocation(text, cursor, lText.substring(piv), formatting);
        }
        cursor.collapseToEnd();
    }

    public static void insertParagraphBreak(XText text, XTextCursor cursor) throws IllegalArgumentException {
        text.insertControlCharacter(cursor, (short)0, true);
        cursor.collapseToEnd();
    }

    public static void insertTextAtCurrentLocation(XText text, XTextCursor cursor, String string, List<Formatting> formatting) throws UnknownPropertyException, PropertyVetoException, WrappedTargetException, IllegalArgumentException {
        text.insertString(cursor, string, true);
        XPropertySet xCursorProps = UnoRuntime.queryInterface(XPropertySet.class, (Object)cursor);
        if (formatting.contains((Object)Formatting.BOLD)) {
            xCursorProps.setPropertyValue(CHAR_WEIGHT, Float.valueOf(150.0f));
        } else {
            xCursorProps.setPropertyValue(CHAR_WEIGHT, Float.valueOf(100.0f));
        }
        if (formatting.contains((Object)Formatting.ITALIC)) {
            xCursorProps.setPropertyValue(CHAR_POSTURE, FontSlant.ITALIC);
        } else {
            xCursorProps.setPropertyValue(CHAR_POSTURE, FontSlant.NONE);
        }
        if (formatting.contains((Object)Formatting.SMALLCAPS)) {
            xCursorProps.setPropertyValue(CHAR_CASE_MAP, (short)4);
        } else {
            xCursorProps.setPropertyValue(CHAR_CASE_MAP, (short)0);
        }
        if (formatting.contains((Object)Formatting.SUBSCRIPT)) {
            xCursorProps.setPropertyValue(CHAR_ESCAPEMENT, (byte)-101);
            xCursorProps.setPropertyValue(CHAR_ESCAPEMENT_HEIGHT, (byte)58);
        } else if (formatting.contains((Object)Formatting.SUPERSCRIPT)) {
            xCursorProps.setPropertyValue(CHAR_ESCAPEMENT, (byte)101);
            xCursorProps.setPropertyValue(CHAR_ESCAPEMENT_HEIGHT, (byte)58);
        } else {
            xCursorProps.setPropertyValue(CHAR_ESCAPEMENT, (byte)0);
            xCursorProps.setPropertyValue(CHAR_ESCAPEMENT_HEIGHT, (byte)100);
        }
        if (formatting.contains((Object)Formatting.UNDERLINE)) {
            xCursorProps.setPropertyValue(CHAR_UNDERLINE, (short)1);
        } else {
            xCursorProps.setPropertyValue(CHAR_UNDERLINE, (short)0);
        }
        if (formatting.contains((Object)Formatting.STRIKEOUT)) {
            xCursorProps.setPropertyValue(CHAR_STRIKEOUT, (short)1);
        } else {
            xCursorProps.setPropertyValue(CHAR_STRIKEOUT, (short)0);
        }
        cursor.collapseToEnd();
    }

    public static void insertTextAtCurrentLocation(XText text, XTextCursor cursor, String string, String parStyle) throws WrappedTargetException, PropertyVetoException, UnknownPropertyException, UndefinedParagraphFormatException {
        text.insertString(cursor, string, true);
        XParagraphCursor parCursor = UnoRuntime.queryInterface(XParagraphCursor.class, (Object)cursor);
        XPropertySet props = UnoRuntime.queryInterface(XPropertySet.class, (Object)parCursor);
        try {
            props.setPropertyValue(PARA_STYLE_NAME, parStyle);
        }
        catch (IllegalArgumentException ex) {
            throw new UndefinedParagraphFormatException(parStyle);
        }
        cursor.collapseToEnd();
    }

    public static Object getProperty(Object o, String property) throws UnknownPropertyException, WrappedTargetException {
        XPropertySet props = UnoRuntime.queryInterface(XPropertySet.class, o);
        return props.getPropertyValue(property);
    }

    public static enum Formatting {
        BOLD,
        ITALIC,
        SMALLCAPS,
        SUPERSCRIPT,
        SUBSCRIPT,
        UNDERLINE,
        STRIKEOUT,
        MONOSPACE;

    }
}

