const MOZ_HELP_URI = "chrome://help/content/help.xul";
const MOZILLA_HELP = "chrome://help/locale/mozillahelp.rdf";
//const XULMAKER_HELP = "chrome://xulmaker/locale/xulmaker-help.rdf";
//var helpFileURI = MOZILLA_HELP;
var helpFileURI = "chrome://mozilla_book/locale/mozilla_book.rdf";

// Call this function to display a help topic.
// uri: [chrome uri of rdf help file][?topic]
function openHelp(topic) {
  var topWindow = locateHelpWindow(helpFileURI);
  if ( topWindow ) {
    topWindow.focus();
    topWindow.displayTopic(topic);
  } else {
      var encodedURI = encodeURIComponent(helpFileURI + "?" + ((topic)?topic:""));  
      window.open(MOZ_HELP_URI + "?" + encodedURI, "_blank", "chrome,menubar,toolbar,dialog=no,resizable,scrollbars");
  }
}

function setHelpFileURI(rdfURI) {
  helpFileURI = rdfURI; 
}

// Locate mozilla:help window (if any) opened for this help file uri.
function locateHelpWindow(helpFileURI) {
///////////////////////
if(browserMode) {
	try {
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		//netscape.security.PrivilegeManager.enablePrivilege("UniversalFileAccess");
		netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserWrite");
		//alert("Set security. ");
	} catch (e) {
		alert("Could NOT set security. " + e);
	}
}
///////////////////////
  var windowManager = Components.classes['@mozilla.org/rdf/datasource;1?name=window-mediator'].getService();
  var windowManagerInterface = windowManager.QueryInterface( Components.interfaces.nsIWindowMediator);
  var iterator = windowManagerInterface.getEnumerator( "mozilla:help");
  var topWindow = null;
  while (iterator.hasMoreElements()) {
    var aWindow = iterator.getNext();
    if (aWindow.getHelpFileURI() == helpFileURI) {
      topWindow = aWindow;
      break;  
    }  
  }
  return topWindow;
}
