/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is hultmann localization tools.
 *
 * The Initial Developer of the Original Code is
 * Jeferson Hultmann <hultmann@gmail.com>
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace LocaleInpector
{

internal sealed class MergeIni : Merge
{

private static string m_value;

public MergeIni(IniFile dic) : base(dic)
{
}


protected override string MergeFile(string translatedModule, string path)
{
    IniFile ini = new IniFile(translatedModule + path);
    Dictionary<string, string> keysL10n = ini.LoadHashtable();
    return this.MergeFileEx(keysL10n, path);
}


protected override string MergeFileEx(Dictionary<string, string> keysL10n, string path)
{
    List<string> linesOriginal = (m_dic as IniFile).LoadLines();
    string[] linesTranslated = new string[linesOriginal.Count];

    Dictionary<string, string> keysSource = m_dic.LoadHashtable(); // h:wtf

    //IniFile ini = new IniFile(translatedModule + path);
    //m_translated = ini;
    //Dictionary<string, string> keysL10n = ini.LoadHashtable();

    MatchEvaluator myDelegate = new MatchEvaluator(this.MergeItemCallback);

    string section = string.Empty;
    for (int idx = 0; idx < linesOriginal.Count; idx++) {
        string myLine = linesOriginal[idx];
        string[] keyvalueSource = IniFile.ParseIniLine(myLine);
        if (keyvalueSource == null) {
            linesTranslated[idx] = myLine; // comment
            continue;
        }

        if (keyvalueSource.Length != 2) {
            section = keyvalueSource[0];
            linesTranslated[idx] = myLine;
            continue;
        }


        //string l10nValue = keysL10n[section + "->" + keyvalueSource[0]];
        //if (l10nValue == null) {
        if (keysL10n.ContainsKey(section + "->" + keyvalueSource[0]) == false) {
            // l10nValue = null ==> key not found in translated file
            this.WriteWarning("missing " + path + " => [" + section + "]" + keyvalueSource[0] + ". Using the original value.");
            linesTranslated[idx] = myLine;
        } else {
            string l10nValue = keysL10n[section + "->" + keyvalueSource[0]];
            // replace
            m_value = l10nValue;
            linesTranslated[idx] = Regex.Replace(myLine, @"=(\s*).*", myDelegate);
            string err = TestIniString(myLine, linesTranslated[idx]); // bug: test includes keyname
            if (err != null) {
                linesTranslated[idx] = myLine;
                this.WriteWarning(err + ": " + path + " => [" + section + "]" + keyvalueSource[0] + ". Using the original value.");
            }
        }
    }

    //return string.Join(Strings.FindEol(m_dic.Content), linesTranslated);
    return string.Join(m_dic.Eol, linesTranslated);
}


private string MergeItemCallback(Match match)
{
    GroupCollection groups = match.Groups;
    return "=" + groups[1].Value + m_value;
}


public static string TestIniString(string o, string t)
{
    string err;
    err = PlaceholderExpressionsTest.CompareCore(o, t);
    if (err != null) {
        return err;
    }
    return err;
}

}//class
}//ns
