
// no prefs...
const buildhelp_version = "0.9";
const content_extension = ".xhtml";

const glossary_name = "glossary";
const glossary_file = glossary_name + content_extension;	// input
const glossary_rdf = glossary_name + ".rdf";							// output
const glossary_base = "chrome://help/locale/" + glossary_file;

const toc_files = "files.rdf";	// input
const toc_rdf = "toc.rdf";			// output

const index_rdf = "index.rdf";			// output
const context_rdf = "context.rdf";	// output

const temp_zip = "$.zip";


const PREF = Components
	.classes['@mozilla.org/preferences-service;1']
	.getService(Components.interfaces.nsIPrefService)
	.getBranch("buildhelp.");
const RDF = Components
	.classes['@mozilla.org/rdf/rdf-service;1']
	.getService(Components.interfaces.nsIRDFService);
const RCU = Components
	.classes['@mozilla.org/rdf/container-utils;1']
	.getService(Components.interfaces.nsIRDFContainerUtils);


var locale_list = null;	// <listbox> element
var project_name = "";	// set by setProject()
var current_locale = "";	// set by build()
var base = null; // nsIFile, base directory, set by localeLoad()

// defaults, overridden by prefs...
var base_locale = "en-US";
var selected_locale = "en-US";

var rdf_dtd = [
	"chrome://calendarhelpdtd/content/parent.dtd",
	"chrome://calendarhelp/locale/help.dtd",
	"chrome://calendarhelp/content/xhtml11.dtd"
	];

var zip_shell = "C:\\WINDOWS\\COMMAND.COM";
var zip_shell_opts = "/C";
var zip_script = "ZIP.BAT";


window.onload = function () {
	document.getElementById("title").value =
		"BuildHelp v" + buildhelp_version;

	try {
		document.getElementById("package").value = PREF.getCharPref("package");
		}
	catch (e) {
		document.getElementById("package").value = "calendarhelp";
		}
	setProject();

	try {
		base_locale = PREF.getCharPref("locale.base");
		} catch (e) {}

	try {
		selected_locale = PREF.getCharPref("locale.selected");
		} catch (e) {}

	try {
		document.getElementById("base").value = PREF.getCharPref("base");
		} catch (e) {}
	locale_list = document.getElementById("locale");
	setLocale();

	try {
		document.getElementById("version").value = PREF.getCharPref("version");
		} catch (e) {}

	try {
		var dtd = PREF.getCharPref("dtd.1");
		rdf_dtd = [dtd];
		for (n = 2; true; ++n) {
			dtd = PREF.getCharPref("dtd." + n);
			rdf_dtd.push(dtd);
			}
		}
	catch (e) {}

	try {
		var b = PREF.getCharPref("build");
		buildSetList(b);
		}
	catch (e) {
		buildSelect(false);
		}

	try {
		zip_shell = PREF.getCharPref("zip.shell");
		} catch (e) {}

	try {
		zip_shell_opts = PREF.getCharPref("zip.shell.opts");
		} catch (e) {}

	try {
		zip_script = PREF.getCharPref("zip.script");
		} catch (e) {}

	}

window.onunload = function () {
	PREF.setCharPref("base", document.getElementById("base").value);
	PREF.setCharPref("package", document.getElementById("package").value);
	PREF.setCharPref("version", document.getElementById("version").value);
	PREF.setCharPref("locale.base", base_locale);
	for (var i = 0; i < rdf_dtd.length; ++i) {
		PREF.setCharPref("dtd." + (i + 1), rdf_dtd[i]);
		}
	PREF.setCharPref("build", buildGetList());
	PREF.setCharPref("zip.shell", zip_shell);
	PREF.setCharPref("zip.shell.opts", zip_shell_opts);
	PREF.setCharPref("zip.script", zip_script);
	localeSave();
	PREF.setCharPref("locale.selected", selected_locale);
	}

function setProject() {
	project_name = document.getElementById("package").value;
	setLocale();
	}



// locale list...
function setLocale() {
	localeLoad();
	}

function localeLoad() {
	base = null;

	var b = document.getElementById("base").value;
	if (b == "") return;

	try {
		var d = Components.classes["@mozilla.org/file/local;1"]
			.createInstance(Components.interfaces.nsILocalFile);
		d.initWithPath(b);
		if (d.isDirectory()) base = d;
		d.append(project_name);
		d.append("locale");

		var c;
		while (c = locale_list.firstChild) locale_list.removeChild(c);

		var e = d.directoryEntries;
		while (e.hasMoreElements()) {
			var l = e.getNext()
				.QueryInterface(Components.interfaces.nsIFile);
			if (l.isDirectory()) {
				var n = l.leafName;
				if (n.indexOf("-") > 0) {
					c = locale_list.appendItem(n);
					if (selected_locale.indexOf(n) >= 0) locale_list.selectItem(c);
					}
				}
			}
		}
	catch (e) {}
	}

function localeSelect(a) {
	if (a) locale_list.selectAll();
	else locale_list.clearSelection();
	}

function localeSave() {
	var s = "";
	for (var i = 0; i < locale_list.selectedCount; ++i) {
		if (s != "") s += ",";
		s += locale_list.getSelectedItem(i).label;
		}
	selected_locale = s;
	}


// build list...
function buildSelect(a) {
	var c = document.getElementById("build").firstChild;
	while (c) {
		c.checked = a;
		c = c.nextSibling;
		}
	}

function buildGetList() {
	var c = document.getElementById("build").firstChild;
	var t = "";
	while (c) {
		if (c.checked) t += c.label.charAt(0);
		c = c.nextSibling;
		}
	return t;
	}

function buildSetList(t) {
	buildSelect(false);
	var b = document.getElementById("build");
	for (var i = 0; i < t.length; ++i) {
		var c = b.firstChild;
		var x = t.charAt(i);
		while (c) {
			if (x == c.label.charAt(0)) {
				c.checked = true;
				break;
				}
			c = c.nextSibling;
			}
		}
	}



// build - main entry point...
function build() {
	clearStatus();

	if (locale_list.selectedCount == 0) {
		errormsg("No locale selected");
		return;
		}

	var a = locale_list.selectedItems;
	for (var i = 0; i < a.length; ++i) {
		current_locale = a[i].label;
		if (document.getElementById("doGlossary").checked) buildglossary();
		if (document.getElementById("doIndex").checked)    buildindex();
		if (document.getElementById("doContents").checked) buildcontents();
		if (document.getElementById("doContext").checked)  buildcontext();
		if (document.getElementById("doJar").checked)      buildjar();
		if (document.getElementById("doInstall").checked)  buildxpi();
		}
	}


// xpi - main entry point...
function buildxpi() {
	// get various directories...
	var basedir = Components.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	basedir.initWithPath(document.getElementById("base").value);
	basedir.append(project_name);

	var install = basedir.clone();
	install.append("install");

	var locale = install.clone();
	locale.append(current_locale);

	// copy common files to locale...
	var copies = [];
	var e = install.directoryEntries;
	while (e.hasMoreElements()) {
		var f0 = e.getNext()
			.QueryInterface(Components.interfaces.nsIFile);
		if (f0.isFile() && f0.leafName != "README") {
			var f1 = locale.clone();
			f1.append(f0.leafName);
			if (!f1.exists()) {
				f0.copyTo(locale, "");
				copies.push(f1);
				}
			}
		}

	// set up zip script...
	var script;
	with (basedir.clone()) {
		append("build");
		append(zip_script);
		script = path;
		}

	var tempfile = locale.clone();
	tempfile.append(temp_zip);
	if (tempfile.exists()) tempfile.remove(false);

	var drive;
	var d = locale.path;
	drive = (d.charAt(1) == ":")? d.charAt(0) + ":" : "-";

	// run shell...
	var s = Components.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	s.initWithPath(zip_shell);

	var shell = Components.classes["@mozilla.org/process/util;1"]
		.createInstance(Components.interfaces.nsIProcess);
	shell.init(s);

	var args = [
		zip_shell_opts,
		script,
		drive,
		locale.path
		];
	shell.run(true, args, args.length);

	// change name...
	var download = locale.clone();
	var v = document.getElementById("version").value;
	download.append(
		project_name +
		((v == "")? v : "-" + v) +
		"-" + current_locale +
		".xpi"
		);
	if (download.exists()) download.remove(false);
	tempfile.moveTo(null, download.leafName);

	// remove copies from locale...
	for (var i = 0; i < copies.length; ++i)
		copies[i].remove(false);

	showStatus("xpi", true);
	}


// jar - main entry point...
function buildjar() {
	// get the base directory and various paths...
	var basedir = Components.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	basedir.initWithPath(document.getElementById("base").value);
	basedir.append(project_name);

	var script;
	with (basedir.clone()) {
		append("build");
		append(zip_script);
		script = path;
		}

	var jarname = project_name + ".jar";

	var tempfile = basedir.clone();
	tempfile.append(temp_zip);

	var drive;
	var d = tempfile.path;
	drive = (d.charAt(1) == ":")? d.charAt(0) + ":" : "";

	var locale;
	with (basedir.clone()) {
		append("locale");
		append(current_locale);
		locale = path.substr(basedir.path.length + 1);
		}

	// run script...
	var s = Components.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	s.initWithPath(zip_shell);

	var shell = Components.classes["@mozilla.org/process/util;1"]
		.createInstance(Components.interfaces.nsIProcess);
	shell.init(s);
	var args = [
		zip_shell_opts,
		script,
		drive,
		basedir.path,
		current_locale
		];
	shell.run(true, args, args.length);

	// put jar in its place...
	var destination = basedir.clone();
	with (destination) {
		append("install");
		append(current_locale);
		append("chrome");
		}
	if (!destination.exists()) destination.createUnique(1, 420);

	with (destination.clone()) {
		append(jarname);
		if (exists()) remove(false);
		}
	tempfile.moveTo(destination, jarname);

	showStatus("jar", true);
	}




// context - main entry point...
function buildcontext() {
	// create RDF...
	var rdf = new RDFfile(contentdirectory(), context_rdf);

	// process all the source files...
	var s = xhtmllist();
	var i;
	for (i = 0; i < s.length; ++i) ctxprocess(rdf, s[i]);

	rdf.close();

	showStatus("context", true);
	}


// context - process a source file...
function ctxprocess(rdf, f) {
	try {
		var parser = Components.classes["@mozilla.org/xmlextras/domparser;1"]
			.createInstance(Components.interfaces.nsIDOMParser);

		var stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
			.createInstance(Components.interfaces.nsIFileInputStream);
		stream.init(f, 1, 292, null);

		var io = Components.classes["@mozilla.org/scriptableinputstream;1"]
			.createInstance(Components.interfaces.nsIScriptableInputStream);
		io.init(stream);

		var doc = parser.parseFromString(
			fixamp(io.read(f.fileSize - 1)),
			"text/xml");

		io.close();
		stream.close();

		var h1id = doc.getElementsByTagName("h1")[0].id;

		var s = doc.getElementsByTagName("context");
		var i;
		for (i = 0; i < s.length; ++i) {
			var id = s[i].parentNode.id;
			var wind = s[i].getAttribute("window");
			var elem = s[i].getAttribute("element");
			if (id != "" && wind != "" && elem != "") {
				rdf.addLine('<rdf:Description '
					+ 'nc:name="' + wind + ":" + elem + '" '
					+ 'nc:topic="' + h1id + ":" + s[i].parentNode.id + '"'
					+ '/>');
				}
			}
		}
	catch (e) {
		alert("ERROR contextprocess\n" + e);
		showStatus("context failed in " + f.leafName, false);
		}	
	}


// toc - main entry point...
function buildcontents() {
	try {
		var fs = RDF.GetDataSourceBlocking("file:///" + directory() + "\\" + toc_files);

		var seq = fs.GetTarget(
			RDF.GetResource("urn:root"),
			RDF.GetResource("http://home.netscape.com/NC-rdf#subheadings"),
			true);
		if (!seq) throw "Null seq in urn:root";

		var list = new Array();
		var e = RCU.MakeSeq(fs, seq).GetElements();
		while (e.hasMoreElements()) {
			var f = e.getNext();
			var l = fs.GetTarget(
				f,
				RDF.GetResource("http://home.netscape.com/NC-rdf#link"),
				true);
			list.push(l.QueryInterface(Components.interfaces.nsIRDFLiteral).Value);
			}

		var rdf = new RDFfile(directory(), toc_rdf);
		var root = new RDFlist("urn:root", null, null);

		var i;
		for (i = 0; i < list.length; ++i) {
			tocprocess(rdf, root, list[i]);
			}

		rdf.addLine(root.value());
		rdf.close();

		showStatus("ToC (" + list.length + " files)", true);
		}
	catch (e) {
		alert("ERROR buildcontents\n" + e);
		showStatus("ToC failed", false);
		return;
		}
	}


// toc - process file f...
function tocprocess(rdf, root, f) {
	try {
		var parser = Components.classes["@mozilla.org/xmlextras/domparser;1"]
			.createInstance(Components.interfaces.nsIDOMParser);

		var html = Components.classes["@mozilla.org/file/local;1"]
			.createInstance(Components.interfaces.nsILocalFile);
		html.initWithPath(directory());
		html.append(f);

		var stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
			.createInstance(Components.interfaces.nsIFileInputStream);
		stream.init(html, 1, 292, null);

		var io = Components.classes["@mozilla.org/scriptableinputstream;1"]
			.createInstance(Components.interfaces.nsIScriptableInputStream);
		io.init(stream);

		var doc = parser.parseFromString(
			fixamp(io.read(html.fileSize - 1)),
			"text/xml");

		io.close();
		stream.close();

		var h1list = null, h1id = "";
		var h2list = null, h2id = "";

		var h = doc.getElementsByTagName("h1")[0];
		if (!h) throw "No h1"
		while (h) {
			var tag = h.localName;
			var id = h.getAttribute("id");
			var txt = trim(h.firstChild.nodeValue);
			var rdfid;
			if (tag == "h1") {
				rdfid = "#" + id;
				root.add(rdfid, txt, f + rdfid);
				if (h1list && h1list.islist) rdf.addLine(h1list.value());
				h1list = new RDFlist(rdfid, null, null);
				h1id = id;
				}
			else if (tag == "h2") {
				rdfid = "#" + h1id + ":" + id;
				if (!h1list) alert("ERROR h2 tag sequence in " + f + " id " + id);
				h1list.add(rdfid, txt, f + "#" + id);
				if (h2list && h2list.islist) rdf.addLine(h2list.value());
				h2list = new RDFlist(rdfid, null, null);
				h2id = id;
				}
			else if (tag == "h3") {
				rdfid = "#" + h2id + ":" + id;
				if (!h2list) alert("ERROR h3 tag sequence in " + f + " id " + id);
				h2list.add(rdfid, txt, f + "#" + id);
				}
			h = h.nextSibling;
			while (h && h.localName != "h2" && h.localName != "h3") h = h.nextSibling;
			}
		if (h2list && h2list.islist) rdf.addLine(h2list.value());
		if (h1list && h1list.islist) rdf.addLine(h1list.value());
		}
	catch (e) {
		showStatus("Can't read source file " + f, false);
		return null;
		}
	}




// index - main entry point...
function buildindex() {
	var ix = new index();

	// process all the source files...
	var s = xhtmllist();
	var i;
	for (i = 0; i < s.length; ++i) indexprocess(ix, root, s[i]);

	// create RDF...
	var rdf = new RDFfile(directory(), index_rdf);

	// add entries to RDF...
	var root = new RDFlist("urn:root", null, null);	// list of capital letters
	var headlist = null;	// list of name1s for current capital
	var sublist = null;		// list of name2s for current name1

	var thisentry = ix.getFirstEntry();
	var prevcap = "";		// previous capital
	var prevhead = "";	// previous name1
	while (thisentry) {
		var nextentry = thisentry.nextEntry;

		// check for duplicate entry following...
		var duplicated = false;
		if (nextentry && thisentry.name.toLowerCase() == nextentry.name.toLowerCase()) {
			showStatus("index: duplicate entry - " + thisentry.name, false);
			duplicated = true;
			}

		// add capital letter to root if needed...
		var thiscap  = thisentry.name.charAt(0).toLowerCase();
		if (thiscap != prevcap) {
			root.add("#" + thiscap, thiscap.toUpperCase(), null);
			if (headlist) rdf.addLine(headlist.value());
			headlist = new RDFlist("#" + thiscap, null, null);
			prevcap = thiscap;
			}

		// add name1 to headlist if needed...
		var thishead = thisentry.name1.toLowerCase();
		var headonly = (thisentry.name2 == "");
		if (thishead != prevhead) {
			var paired = (nextentry && nextentry.name1.toLowerCase() == thishead);
			var needsub = (paired && !duplicated);
			var needlink = (!paired || headonly);
			headlist.add(
				(needsub)? "index:" + thishead : null,
				thisentry.name,
				(needlink)? thisentry.link : null);
			if (sublist) rdf.addLine(sublist.value());
			if (needsub) sublist = new RDFlist("index:" + thishead, null, null);
				else sublist = null;
			prevhead = thishead;
			}

		// add name2 to sublist if needed...
		if (sublist && !headonly) {
			sublist.add(null, thisentry.name2, thisentry.link);
			}

		// move on...
		thisentry = nextentry;
		}

	if (headlist) rdf.addLine(headlist.value());
	if (sublist) rdf.addLine(sublist.value());
	rdf.addLine(root.value());

	rdf.close();

	showStatus("index", true);
	}



// index - process a source xhtml file...
function indexprocess(ix, root, f) {
	try {
		var parser = Components.classes["@mozilla.org/xmlextras/domparser;1"]
			.createInstance(Components.interfaces.nsIDOMParser);

		var stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
			.createInstance(Components.interfaces.nsIFileInputStream);
		stream.init(f, 1, 292, null);

		var io = Components.classes["@mozilla.org/scriptableinputstream;1"]
			.createInstance(Components.interfaces.nsIScriptableInputStream);
		io.init(stream);

		var doc = parser.parseFromString(
			fixamp(io.read(f.fileSize - 1)),
			"text/xml");

		io.close();
		stream.close();

		var s = doc.getElementsByTagName("index");
		var i;
		for (i = 0; i < s.length; ++i) {
			indextag(ix, s[i], f.leafName);
			}
		}
	catch (e) {
		showStatus("index failed", false);
		alert("ERROR indexprocess\n" + e);
		}	
	}

// index - process index tag...
function indextag(ix, e, f) {
	var t = e.firstChild;
	if (!t) return;

	var s = t.nodeValue;
	if (!s || s == "") return;

	ix.addEntry(s, f + "#" + e.parentNode.getAttribute("id"));
	}


// index class sorts index entries alphabetically...
function index() {
	this.start = null;
	}

index.prototype = {
	addEntry: function (n, l) {
		var e = new indexEntry(n, l);
		var p = this.start;
		if (!p) {
			this.start = e;
			return;
			}
		
		if (p.sortname >= e.sortname) {
			e.nextEntry = p;
			this.start = e;
			return;
			}

		var q = p.nextEntry;
		while (q && q.sortname < e.sortname) {
			p = q;
			q = q.nextEntry;
			}
		e.nextEntry = p.nextEntry;
		p.nextEntry = e;
		},

	getFirstEntry: function () {
		return this.start;
		},

	getNextEntry: function (entry) {
		return entry.nextEntry;
		}
	}


// index entry class represents an entry...
function indexEntry(n, l) {
	this.name = n;
	this.sortname = n.toLowerCase();
	this.link = l;
	this.nextEntry = null;

	var c = n.indexOf(",");
	if (c >= 0) {
		this.name1 = n.substr(0, c);
		this.name2 = n.substr(c + 1);
		}
	else {
		this.name1 = n;
		this.name2 = "";
		}
	}

// index - all source text in array of nsIFile...
function xhtmllist() {
	try {
		var f = new Array();
		var p = directory();

		var d = Components.classes["@mozilla.org/file/local;1"]
			.createInstance(Components.interfaces.nsILocalFile);
		d.initWithPath(p);

		var e = d.directoryEntries;
		var en = content_extension.length;
		while (e.hasMoreElements()) {
			var n = e.getNext();
			var l = n.QueryInterface(Components.interfaces.nsIFile).leafName;
				if (l.substr(l.length - en) == content_extension) f.push(n);
			}
		}
	catch (e) {
		showStatus("Can't read directory" + p, false);
		return null
		}
	
	return f;
	}



// glossary - main entry point...
function buildglossary() {
	var terms = glossaryterms();
	if (!terms) return;

	try {
		var rdf = new RDFfile(directory(), glossary_rdf);

		var root = new RDFlist("urn:root");
		root.base = glossary_base;

		for (i = 0; i < terms.length; ++i) {
			var t = terms[i];
			root.add(
				null,
				trim(t.firstChild.nodeValue),
				glossary_file + "#" + t.getAttribute("id"));
			}

		rdf.addLine(root.value());
		rdf.close();

		showStatus("glossary", true);	
		}
	catch (e) {
		alert(e);
		showStatus("glossary failed", false);
		return;
		}
	}

// glossary - get <dt> elements from source file...
function glossaryterms() {
	try {
		var parser = Components.classes["@mozilla.org/xmlextras/domparser;1"]
			.createInstance(Components.interfaces.nsIDOMParser);

		var glos = Components.classes["@mozilla.org/file/local;1"]
			.createInstance(Components.interfaces.nsILocalFile);
		glos.initWithPath(directory());
		glos.append(glossary_file);

		var stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
			.createInstance(Components.interfaces.nsIFileInputStream);
		stream.init(glos, 1, 292, null);

		var io = Components.classes["@mozilla.org/scriptableinputstream;1"]
			.createInstance(Components.interfaces.nsIScriptableInputStream);
		io.init(stream);

		var doc = parser.parseFromString(
			fixamp(io.read(glos.fileSize - 1)),
			"text/xml");

		io.close();
		stream.close();

		return doc.getElementsByTagName("dt");
		}
	catch (e) {
		showStatus("Can't read glossary source file", false);
		return null;
		}
	}


// glossary class sorts glossary entries alphabetically...
function glossary() {
	this.start = null;
	}

glossary.prototype = {
	addEntry: function (id, term, def) {
		var e = new indexEntry(id, term, def);
		var p = this.start;
		if (!p) {
			this.start = e;
			return;
			}
		
		if (p.sortname >= e.sortname) {
			e.nextEntry = p;
			this.start = e;
			return;
			}

		var q = p.nextEntry;
		while (q && q.sortname < e.sortname) {
			p = q;
			q = q.nextEntry;
			}
		e.nextEntry = p.nextEntry;
		p.nextEntry = e;
		},

	getFirstEntry: function () {
		return this.start;
		},

	getNextEntry: function (entry) {
		return entry.nextEntry;
		}
	}


// glossary entry class represents an entry...
function glossaryEntry(id, term, def) {
	this.term = term;
	this.sortname = term.toLowerCase();
	this.def = def;
	this.id = id;
	this.nextEntry = null;
	}



// rdf file class...
function RDFfile(directory, name) {
	var f = Components
		.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	f.initWithPath(directory);
	f.append(name);
	if (f.exists()) f.remove(false);
	f.create(0, 420);

	var s = Components
		.classes["@mozilla.org/network/file-output-stream;1"]
		.createInstance(Components.interfaces.nsIFileOutputStream);
	s.init(f, 0x24, 292, null);

	var head = '<?xml version="1.0"?>'
		+ '\n<!-- DO NOT EDIT this file -->'
		+ '\n<!DOCTYPE rdf:RDF [';

	for (var i = 0; i < rdf_dtd.length; ++i) {
		var dtd = rdf_dtd[i];
		var dn = dtd.match(/\/([^\/]*)\.dtd/i)[1];
		dn += 'DTD';
		head += '\n\t<!ENTITY % ' + dn + ' SYSTEM "' + dtd + '"> %' + dn + ';'
		}

	head += '\n\t]>\n'
		+ '\n<rdf:RDF'
		+ '\n\txmlns:nc="http://home.netscape.com/NC-rdf#"'
		+ '\n\txmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">';
	s.write(head, head.length);

	this.file = f;
	this.stream = s;
	}

RDFfile.prototype = {

	addLine: function (txt) {
		this.stream.write("\n", 1);
		this.stream.write(txt, txt.length);
		},

	close: function () {
		var tail = '\n\n</rdf:RDF>';
		this.stream.write(tail, tail.length);
		this.stream.close();
		}
	}



// RDFlist class...
function RDFlist(about, name, link) {
	this.text = '\n<rdf:Description about="' + about + '"';
	if (name) this.text +=	' nc:name="' + name + '"';
	if (link) this.text +=	' nc:link="' + link + '"';
	this.islist = false;
	this.count = 0;
	this.about = about;
	this.lastname = "";
	this.lastlink = "";
	}

RDFlist.prototype = {
	add: function (about, name, link) {
		if (!this.islist) {
			this.text += '>'
				+ '\n\t<nc:subheadings>'
				+ '\n\t\t<rdf:Seq>';
			this.islist = true;
			}
		this.text += '\n\t\t\t<rdf:li><rdf:Description';
		if (about) this.text += ' about="' + about + '"';
		if (name) this.text += ' nc:name="' + name + '"';
		if (link) this.text += ' nc:link="' + link + '"';
		this.text += '/></rdf:li>';
		this.count += 1;
		this.lastname = name;
		this.lastlink = link;
		},

	value: function () {
		if (!this.islist) {
			this.text += '/>';
			}
		else {
			this.text += '\n\t\t</rdf:Seq>'
		    + '\n\t</nc:subheadings>'
				+ '\n</rdf:Description>';
			}
		return this.text;
		},

	set base (b) {
		if (!this.islist) this.text += ' nc:base="' + b + '"';
		}
	}



// miscellaneous...
function showStatus(m, ok) {
	document.getElementById("status").value +=
		((ok)? "OK: " : "ERROR: ") + current_locale + " " + m + "\n";
	}

function clearStatus() {
	var d = new Date();
	document.getElementById("status").value = d.toString() + "\n";
	}

function directory() {
	var f = Components.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	f.initWithPath(document.getElementById("base").value);
	f.append(project_name);
	f.append("locale");
	f.append(current_locale);
	f.append(project_name);
	return f.path;
	}

function contentdirectory() {
	var f = Components.classes["@mozilla.org/file/local;1"]
		.createInstance(Components.interfaces.nsILocalFile);
	f.initWithPath(document.getElementById("base").value);
	f.append(project_name);
	f.append("content");
	f.append(project_name);
	return f.path;
	}

function fixlocale(s) {
	return s
		.replace(/chrome:\/\/calendarhelpdtd\/content\//, "chrome://buildhelp/content/")
		.replace(/chrome:\/\/calendarhelp\/locale\//, "chrome://buildhelp/content/")
		.replace(/chrome:\/\/calendarhelp\/content\//, "chrome://buildhelp/content/");
	}

function fixamp(s) {
	return s
		.replace(/&/g, "&#38;")
		.replace(/<!ENTITY [^;]+;/g, "");
	}

function trim(s) {
	while ((p = s.indexOf("\n")) >= 0) s = s.substr(0, p);
	return s;
	}

function errormsg(m) {
	var p = Components
		.classes["@mozilla.org/embedcomp/prompt-service;1"]
		.getService(Components.interfaces.nsIPromptService)
		.alert(self, "BuildHelp Error", m);
	}
