unit Globals;
{Globals unit for GeckoBrowser-D4, contains global vars + inifile methods}
{v1.0 Written by Dave Murray <irongut@vodafone.net>, October - November 2003}
{v1.1 for Delphi 4 Written by Dave Murray, Febuary 2004}
{v1.2 for Delphi 4 Written by Dave Murray, October 2004}
{GeckoBrowser v1.2 was written using Mozilla ActiveX Control v1.7.1}

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is GeckoBrowser framework for Delphi 4.
 *
 * The Initial Developer of the Original Code is
 * Conspiracy Software.
 * Portions created by the Initial Developer are Copyright (C) 2003 - 2004
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Dave Murray <irongut@vodafone.net>
 *   Sterling Bates <sblistserv@bigbangco.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)


interface


procedure ReadIniFile;
procedure WriteIniFile;


const
  PROGRAM_TITLE = 'GeckoBrowser v1.2-D4';
  MOZILLA_VERSION = 'Mozilla ActiveX Control v1.7.1';
  INI_FILENAME = 'GeckoBrowser.ini';


var
  PROGRAM_PATH : string;
  HOME_ADDRESS : string;
  START_TYPE : integer;
  START_ADDRESS : string;


implementation

uses SysUtils, IniFiles;

procedure ReadIniFile;
{reads prefs from inifile}
var
  GBini : TIniFile;
begin
  {create inifile}
  GBini := TIniFile.Create(PROGRAM_PATH + INI_FILENAME);
  try
    try
      {read prefs}
      HOME_ADDRESS := GBini.ReadString('Browser', 'Home', 'http://www.mozilla.org/');
      START_TYPE := GBini.ReadInteger('Browser', 'StartType', 0);
      START_ADDRESS := GBini.ReadString('Browser', 'StartAddress', 'http://www.mozilla.org/');
    except
      {handle exceptions}
      on E : Exception do begin
        E.message := 'ERROR: There was a problem reading the inifile';
        raise;
        end; {on E..}
      end; {try..except..}
    finally
      {free inifile}
      GBini.Free;
      end; {try..finally..}
end; {procedure ReadIniFile}

procedure WriteIniFile;
{writes prefs to inifile}
var
  GBini : TIniFile;
begin
  {create inifile}
  GBini := TIniFile.Create(PROGRAM_PATH + INI_FILENAME);
  try
    try
      {write prefs}
      GBini.WriteString('Browser', 'Home', HOME_ADDRESS);
      GBini.WriteInteger('Browser', 'StartType', START_TYPE);
      GBini.WriteString('Browser', 'StartAddress', START_ADDRESS);
    except
      {handle exceptions}
      on E : Exception do begin
        E.message := 'ERROR: There was a problem writing to the inifile';
        raise;
        end; {on E..}
      end; {try..except..}
    finally
      {free inifile}
      GBini.Free;
      end; {try..finally..}
end; {procedure WriteIniFile}


initialization
  PROGRAM_PATH := ExtractFilePath(ParamStr(0));
  ReadIniFile;


finalization
  WriteIniFile;


end.
