unit JSBrowser;
{Classes and functions for Demo1, a simple demo of running JavaScript in SpiderMonkey }
{Part of the Mozilla-Delphi Project: http://delphi.mozdev.org/ }

(* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JavaScript Bridge Demo1.
 *
 * The Initial Developer of the Original Code is
 * Theo Lustenberger <theo@theo.ch>.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Dave Murray <irongut@vodafone.net>
 *   Dominique Louis <dominique@savagesoftware.com.au>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** *)

interface

{$J+}

uses
  js15decl, jsintf, Classes;

var GlobWriteObj : TStrings;

type
  TBrowserBase = class
  private
    fengine: TJSEngine;
    fStatus:String;
    fOnStatus:TNotifyEvent;
    procedure setWriteObj(Strings:TStrings);
  protected
  public
    constructor Create;
    destructor Destroy; override;
    procedure CreateObjects;
    procedure GarbageCollect;
    procedure RunScript(Script:String);
    procedure SetStatus(StatusText:String);
    property Status: String read fStatus;
    property WriteObj:TStrings write setWriteObj;
    property OnStatus: TNotifyEvent read fOnStatus write fOnStatus;
  published
  end; {TBrowserBase}

var
  GlobBrowserBase : TBrowserBase;

const
  my_def: JSClass = (name: 'my'; flags: JSCLASS_HAS_PRIVATE; addProperty: JS_PropertyStub;
    delProperty: JS_PropertyStub; getProperty: JS_PropertyStub; setProperty: JS_PropertyStub;
    enumerate: JS_EnumerateStub; resolve: JS_ResolveStub; convert: JS_ConvertStub;
    finalize: JS_FinalizeStub);

function BR_writeln(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
function BR_open(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
function BR_alert(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
function BR_prompt(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
function BR_Set_Status(cx: PJSContext; obj: PJSObject; id: jsval; vp: pjsval): JSBool; cdecl;
function BR_Get_Status(cx: PJSContext; obj: PJSObject; id: jsval; vp: pjsval): JSBool; cdecl;

implementation

uses
  QDialogs, SysUtils;

constructor TBrowserBase.Create;
begin
  fEngine := TJSEngine.Create(40000);
  GlobBrowserBase := self;
  CreateObjects;
end;

destructor TBrowserBase.Destroy;
begin
  fEngine.Free;
  inherited;
end;

procedure TBrowserBase.RunScript(Script:String);
begin
  fEngine.Evaluate(Script);
end;

procedure TBrowserBase.setWriteObj(Strings:TStrings);
begin
  GlobWriteObj := Strings;
end;

procedure TBrowserBase.CreateObjects;
var
  doc, wind: TJSObject;
  myfuncs: TJSFunctionSpecArray;
  myprops: TJSPropertySpecArray;
	global: TJSObject;
begin
  global := fEngine.Global;

  doc := global.AddObject(my_def, 'document');

  SetLength(myfuncs, 2);
  myfuncs[0].name := 'writeln';
  myfuncs[0].call := BR_writeln;
  myfuncs[0].nargs := 1;
  myfuncs[1].name := 'open';
  myfuncs[1].call := BR_open;
  myfuncs[1].nargs := 0;
  doc.AddMethods(myfuncs);

  wind := global.AddObject(my_def, 'window');
  SetLength(myprops,1);
  myprops[0].name:='status';
  myprops[0].setter:=BR_Set_Status;
  myprops[0].tinyid:=0;
  myprops[0].getter:=BR_Get_Status;
  wind.AddProperties(myprops);

  SetLength(myfuncs, 2);
  myfuncs[0].name := 'alert';
  myfuncs[0].call := BR_alert;
  myfuncs[0].nargs := 1;
  myfuncs[1].name := 'prompt';
  myfuncs[1].call := BR_prompt;
  myfuncs[1].nargs := 2;
  wind.AddMethods(myfuncs);
end;

procedure TBrowserBase.GarbageCollect;
begin
  fEngine.GarbageCollect;
end;

procedure TBrowserBase.SetStatus(StatusText:String);
begin
  fStatus := StatusText;
  if assigned(onStatus) then onStatus(self);
end;


function BR_Set_Status(cx: PJSContext; obj: PJSObject; id: jsval; vp: pjsval): JSBool; cdecl;
begin
  GlobBrowserBase.SetStatus(JSStringToString(JSValToJSString(vp^)));
	Result := JS_TRUE;
end;

function BR_Get_Status(cx: PJSContext; obj: PJSObject; id: jsval; vp: pjsval): JSBool; cdecl;
begin
	vp^ := StringToJSVal(cx,Pchar(GlobBrowserBase.fStatus));
	Result := JS_TRUE;
end;

function BR_writeln(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
begin
	rval^ := JSVAL_VOID;
  if Assigned(GlobWriteObj) then GlobWriteObj.Add(JSStringToString(JSValToJSString(argv^)));
	Result := JS_TRUE;
end;

function BR_open(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
begin
	rval^ := JSVAL_VOID;
  if Assigned(GlobWriteObj) then GlobWriteObj.clear;
	Result := JS_TRUE;
end;

function BR_alert(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
begin
	rval^ := JSVAL_VOID;
  ShowMessage(JSStringToString(JSValToJSString(argv^)));
	Result := JS_TRUE;
end;

function BR_prompt(cx: PJSContext; obj: PJSObject; argc: uintN; argv, rval: pjsval): JSBool; cdecl;
var
  ResString, Mesg, Deflt:String;
  //strval: PJSString;
begin
  if (argc >= 1) and JSValIsString(argv^) then
  begin
   Mesg := JSStringToString(JSValToJSString(argv^));
   inc(argv);
  end;
  if (argc >= 2) and (not JSValIsNumber(argv^)) then
   begin
    Deflt := JSStringToString(JSValToJSString(argv^));
   end;
  ResString := InputBox('[JavaScript Application]', Mesg, Deflt);
  rval^ := jsval(JS_NewStringCopyZ(cx,PChar(ResString))) or JSVAL_STRING;
	Result := JS_TRUE;
end;


end.
