/* 
	FILEMANAGER  --  A FREE CROSS-PLATFORM XUL-BASED FILE MANAGEMENT TOOL
	Author: Duong Thanh An - dgthanhan@gmail.com (core)
	Co-author: Le Phong "Apache" Bao Vuong - apache@7bit.biz (php module)

	Copyright (C) 2004 Anisolution.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Anisolution.com
	http://www.anisolution.com
	HCMC Vietnam
	Duong Thanh An
	dgthanhan@gmail.com


	$Id: ext-folder-navigate.js,v 1.1 2004/11/27 11:58:08 thanh.an Exp $

*/


installExtension(new FolderNavigatorExt());

function FolderNavigatorExt() {

	this.getDisplayInfo = function() {
		var sel = getListSelectionModel();
		if(!sel) return null;
		if(!isSingleFolderSelection(sel)) return null;

		var menuItem = new ExtensionMenuItem();
		menuItem.caption = "Open Folder";
		menuItem.iconImage = "";
		menuItem.action = function () {
			var list = document.getElementById("contentList");
			var index = list.view.selection.currentIndex;
			if(index < 0) return;
			var item = list.view.getItemAtIndex(index);
			if(item.fsData.fstype == "folder") { //navigate
				selectPath(item.fsData.absolutePath);
			}
		};
		return menuItem;
	};

	this.getAboutInfo = function() {
		return "Folder Navigation by Duong Thanh An. Email: dgthanhan@yahoo.com";
	};
}

