!define NAME "PortableFirefox"
!define VER "0.0.2"

!packhdr "C:\tmp.dat" "c:\Program Files\UPX\upx.exe --best --crp-ms=999999 C:\tmp.dat"

;=== Out program information
Name "${NAME}"
OutFile "${NAME}.exe"
Caption "${NAME} - Making Firefox Portable"

CRCCheck On
WindowIcon Off
SilentInstall Silent
AutoCloseWindow True

;=== Set program icon
Icon "unofficial_firefox.ico"

;=== Path variables
Var FIREFOXPATH
Var PROFILEDIRECTORY

Section "Main"
	
	;=== Get the path information from the INI file
	IfFileExists "$EXEDIR\${NAME}.ini" ReadINI NoINI
	ReadINI:
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "firefoxpath"
		StrCpy "$FIREFOXPATH" $0
		ReadINIStr $0 "$EXEDIR\${NAME}.ini" "${NAME}" "profiledirectory"
		StrCpy "$PROFILEDIRECTORY" $0
		IfErrors NoINI EndINI
	NoINI:
		MessageBox MB_OK "Unable to find configuration file $\"$EXEDIR\${NAME}.ini$\". Click OK to exit." IDOK
		Goto TheEnd
	EndINI:

	IfFileExists "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" ChromeFound
		MessageBox MB_YESNO|MB_ICONQUESTION `Unable to locate the profile specified.  If this is your first time running PortableFirefox, the profile may not have been created yet.  Are you sure that the INI file correctly lists the profile you wish to use?` IDYES RunFirefox
		MessageBox MB_OK|MB_ICONINFORMATION `Please correct the INI file to correctly specify the profile you wish to use before re-launching.`
		Abort
	ChromeFound:
	FileOpen $0 "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" r
	FileOpen $R0 "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf.new" w
	ClearErrors ; if there's an error, we're done with the file
	NextLine:
		FileWrite $R0 $4
		FileRead $0 $4
		IfErrors NoMoreLines
		StrCpy $5 $4 39
		;MessageBox MB_OK "$5"
		StrCmp $5 `                   c:baseURL="jar:file:` "" NextLine
		StrCpy $R4 40
	NotYet:
		IntOp $R4 $R4 + 1
		StrCpy $7 $4 10 $R4 ; looking for the point to strip the extension path
		;MessageBox MB_OK "$7"
		StrCmp $7 "extensions" PathFound NotYet
	PathFound:
		StrCpy $5 $4 "" $R4
		;MessageBox MB_OK "The following extension has an absolute path.$\n$\n$5$\n$\nWe'll make it relative, because that's our purpose :)"
		StrCpy $4 `                   c:baseURL="jar:resource:/$PROFILEDIRECTORY/$5` ; the path made relative
		GoTo NextLine
	NoMoreLines:
	FileClose $0
	FileClose $R0
	CopyFiles "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf.old" ; rename it just in case
	CopyFiles "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf.new" "$FIREFOXPATH\$PROFILEDIRECTORY\chrome\chrome.rdf" ; that was our purpose

	RunFirefox:
	Exec "$FIREFOXPATH\firefox.exe -profile $FIREFOXPATH\$PROFILEDIRECTORY\"

	TheEnd:
SectionEnd
