/* indicime.js
 * This script provides input mechanism for Indian Language Scripts with 
 * multiple keyboard layouts(WX, Inscript).
 * Copyright (C) 2006 Surekha Sastry <surekhasastry@gmail.com> 
 * Copyright (C) 2006 Srinivasa Raghavan <raghavan.kandala@gmail.com>
 */

/* ***** BEGIN LICENSE BLOCK ***** 
  * Indic IME is free software; you can redistribute it and/or modify 
  * it under the terms of the GNU General Public License as published by 
  * the Free Software Foundation; either version 2 of the License, or 
  * (at your option) any later version. 

  * This program is distributed in the hope that it will be useful, 
  * but WITHOUT ANY WARRANTY; without even the implied warranty of 
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
  * GNU General Public License for more details. 

  * You should have received a copy of the GNU General Public License 
  * along with this program; if not, write to the Free Software 
  * Foundation, Inc., 59 Temple Place, Suite 330,  
  * Boston, MA 02111-1307, USA. 
  *
  * ***** END LICENSE BLOCK *****/ 



var prevKey = new String();
var keymappings;
var combFlag = false;
var combMaxLength;
var offset;
var isciiTable;
var convertFlag = false;

if (window) 
{
    window.addEventListener('keypress', eventCaptured, false);
}

// This function is not used.
function buildIsciiTable()
{
    isciiTable = new Array();
    isciiTable['2305'] = '161';
    isciiTable['2306'] = '162';
    isciiTable['2307'] = '163';
    isciiTable['2309'] = '164';
    isciiTable['2310'] = '165';
    isciiTable['2311'] = '166';
    isciiTable['2312'] = '167';
    isciiTable['2313'] = '168';
    isciiTable['2314'] = '169';
    isciiTable['2315'] = '170';
    isciiTable['2318'] = '171';
    isciiTable['2319'] = '172';
    isciiTable['2320'] = '173';
    isciiTable['2317'] = '174';
    isciiTable['2322'] = '175';
    isciiTable['2323'] = '176';
    isciiTable['2324'] = '177';
    isciiTable['2321'] = '178';
    isciiTable['2325'] = '180';
    isciiTable['2326'] = '181';
    isciiTable['2327'] = '182';
    isciiTable['2328'] = '183';
    isciiTable['2329'] = '184';
    isciiTable['2330'] = '185';
    isciiTable['2331'] = '186';
    isciiTable['2332'] = '187';
    isciiTable['2333'] = '188';
    isciiTable['2334'] = '189';
    isciiTable['2335'] = '190';
    isciiTable['2336'] = '192';
    isciiTable['2337'] = '193';
    isciiTable['2338'] = '194';
    isciiTable['2339'] = '195';
    isciiTable['2340'] = '196';
    isciiTable['2341'] = '197';
    isciiTable['2342'] = '198';
    isciiTable['2343'] = '199';
    isciiTable['2344'] = '200';
    isciiTable['2345'] = '201';
    isciiTable['2346'] = '202';
    isciiTable['2347'] = '203';
    isciiTable['2348'] = '204';
    isciiTable['2349'] = '205';
    isciiTable['2350'] = '206';
    isciiTable['2351'] = '207';
    isciiTable['2352'] = '208';
    isciiTable['2353'] = '209';
    isciiTable['2354'] = '210';
    isciiTable['2355'] = '211';
    isciiTable['2356'] = '212';
    isciiTable['2357'] = '213';
    isciiTable['2358'] = '214';
    isciiTable['2359'] = '215';
    isciiTable['2360'] = '216';
    isciiTable['2366'] = '218';
    isciiTable['2367'] = '219';
    isciiTable['2368'] = '220';
    isciiTable['2369'] = '221';
    isciiTable['2370'] = '222';
    isciiTable['2371'] = '223';
    isciiTable['2374'] = '224';
    isciiTable['2375'] = '225';
    isciiTable['2376'] = '226';
    isciiTable['2373'] = '227';
    isciiTable['2378'] = '228';
    isciiTable['2379'] = '229';
    isciiTable['2380'] = '230';
    isciiTable['2377'] = '231';
    isciiTable['2378'] = '232';
    isciiTable['2364'] = '233';
    isciiTable['2404'] = '234';
    isciiTable['2406'] = '241';
    isciiTable['2407'] = '242';
    isciiTable['2408'] = '243';
    isciiTable['2409'] = '244';
    isciiTable['2410'] = '245';
    isciiTable['2411'] = '246';
    isciiTable['2412'] = '247';
    isciiTable['2413'] = '248';
    isciiTable['2414'] = '249';
    isciiTable['2415'] = '250';
}

function eventCaptured(evt) 
{
    if (convertFlag && !(evt.ctrlKey || evt.altKey))
    {
        handleCharacter(evt);
    }
}

/*
 * Captures the keyCode and the characterCode of the key pressed.
 * If the keyCode or characterCode is in the ASCII range, fetch
 * the mapping for the key if exists dispatch new event with the
 * character fetched from the map. If it does not exist, then
 * return the key pressed.
 */
function handleCharacter(event) 
{
    var keyCode = event.keyCode ? event.keyCode :
       event.charCode ? event.charCode :
       event.which ? event.which : void 0;
    if( keyCode < 2304 && keyCode != 8)
    {
        var key = String.fromCharCode(keyCode);
	if (keyCode !=8)
        {
            prevKey = prevKey + key;
	}
        if (prevKey.length > combMaxLength)
        {
            prevKey = prevKey.substring(1, prevKey.length);
        }
        var targetKeyCode = getUnicodeChar(prevKey, key);
        if (targetKeyCode != keyCode)
        {
            if(combFlag)
            {
		combFlag = false;
       	        var new_event = document.createEvent("KeyEvents");
	        new_event.initKeyEvent("keypress", true, true, event.view, 
			               false, false, false, false, 
			               8, 0);
	        event.target.dispatchEvent(new_event); 
	    }
       	var new_event1 = document.createEvent("KeyEvents");
	    new_event1.initKeyEvent("keypress", true, true, event.view, 
			           false, false, false, false, 
			           0, (targetKeyCode+parseInt(offset)));
	    event.target.dispatchEvent(new_event1); 
	    event.preventDefault();
	    event.stopPropagation();
        }
   }
   return;
}

/*
 * Returns the mapping for the key passed if exists, otherwise
 * return the key.
 */ 
function getUnicodeChar(keys, curKey)
{
   var key = new String(keys);
   var unicodeChar = null;
   var unicodeCharCode = curKey.charCodeAt(0);
   var mapFound = false;
   while(key.length > 0)
   { 
       // check for the keycombination (prevkey + key)
       try
       {
           unicodeChar = keymappings.getString(key); 
           mapFound = true;
           if(key.length > 1)
           {
              combFlag = true;
           }
           break;
       }
       catch (e)
       {
           key = key.substring(1,key.length);
           continue;
       }
   }
   // Handle special cases for Tamil
   if (mapFound)
   {
       if ( offset == 640) // if the chosen language is TAMIL
       {
           switch (unicodeChar)
	   {
               case '\u0916' : //kha
               case '\u0917' : //ga
               case '\u0918' : { unicodeChar = '\u0915'; break; } //gha
               case '\u0920' : //cha
               case '\u0921' : //ja
               case '\u0922' : { unicodeChar = '\u091F'; break; } //jha
               case '\u0925' :
               case '\u0926' :
               case '\u0927' : { unicodeChar = '\u0924'; break; }
               case '\u092B' :
               case '\u092C' :
               case '\u092D' : { unicodeChar = '\u092A'; break; }
           }
        }
	unicodeCharCode = unicodeChar.charCodeAt(0);
   }
   return unicodeCharCode;
}

/**
 * Based on the keyboard selected, read the appropriate keyboard
 * map file (wx.properties/inscript.properties).
 * combMaxLength is the maximum key combinations used in this
 * layout.
 */
function setSelectedKeyboard(file)
{
   keymappings = document.getElementById(file);
   combMaxLength = parseInt(keymappings.getString("combMaxLength"));
}

/*
 * Sets the language index for the different indian language scripts 
 */
function setLanguageIndex(selectedLanguage)
{
   switch(selectedLanguage) 
   {
      case '-1': 
      {
         offset = 0;
         convertFlag = false;
         break;
      } 
      case '0': 
      {
         offset = 0;
         convertFlag = true;
         break;
      } 
      case '1': 
      {
         offset = (128*1);
         convertFlag = true;
         break;
      } 
      case '2': 
      {
         offset = (128*2);
         convertFlag = true;
         break;
      } 
      case '3': 
      {
         offset = (128*3);
         convertFlag = true;
         break;
      } 
      case '4': 
      {
         offset = (128*4);
         convertFlag = true;
         break;
      } 
      case '5': 
      {
         offset = (128*5);
         convertFlag = true;
         break;
      } 
      case '6': 
      {
         offset = (128*6);
         convertFlag = true;
         break;
      } 
      case '7': 
      {
         offset = (128*7);
         convertFlag = true;
         break;
      } 
      case '8': 
      {
         offset = (128*8);
         convertFlag = true; 
         break;
      } 
      case '9': 
      {
         offset = (128*9);
         convertFlag = true; 
         break;
      } 
   }
  return offset;
}

function about() {
    window.openDialog("chrome://indicime/content/about/about.xul", "indicime-about-dialog", "centerscreen,chrome,modal");
}

function howto() {
    window.openDialog("chrome://indicime/content/help/howto.xul", "indicime-about-dialog", "centerscreen,chrome,modal");
}

/*
 * Loads the url in a new tab
 */
function loadUrl(url){

    var generatedPage = null;

    const newTab = getBrowser().addTab(url);

    getBrowser().selectedTab = newTab;
    generatedPage = window;

    return generatedPage;
}
