/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.toolkit;

import com.trfenv.rlk.Debug;
import javax.swing.*;
import java.awt.event.*;

/**
 *A JTextField object that has a right-click menu with the following options:
 *
 *<ul>
 *  <li>Cut</li>
 *  <li>Copy</li>
 *  <li>Paste</li>
 *  <li>Delete</li>
 *  <li>Select All</li>
 *</ul>
 *
 *Right-click menu cannot be modified, but can be overwritten.
 */
public class MTextField extends JTextField implements ActionListener, MouseListener
{
	private JPopupMenu rclickMenu;

	private JMenuItem mnuCut = new JMenuItem("Cut");
	private JMenuItem mnuCopy = new JMenuItem("Copy");
	private JMenuItem mnuPaste = new JMenuItem("Paste");
	private JMenuItem mnuSelectAll = new JMenuItem("Select All");
	
	public MTextField()
	{
		super();
		
		rclickMenu = new JPopupMenu();
		
		rclickMenu.add(mnuCut);
		rclickMenu.add(mnuCopy);
		rclickMenu.add(mnuPaste);
		rclickMenu.addSeparator();
		rclickMenu.add(mnuSelectAll);
		
		mnuCut.addActionListener(this);
		mnuCopy.addActionListener(this);
		mnuPaste.addActionListener(this);
		mnuSelectAll.addActionListener(this);
		
		addMouseListener(this);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == mnuCut)
		{
			cut();
		}
		else if (e.getSource() == mnuCopy)
		{
			copy();
		}
		else if (e.getSource() == mnuPaste)
		{
			paste();
		}
		else if (e.getSource() == mnuSelectAll)
		{
			selectAll();
		}
	}

	public void mouseClicked(MouseEvent e)
	{
	}
	
	public void mousePressed(MouseEvent e){ maybeShowPopup(e); }
	public void mouseReleased(MouseEvent e){ maybeShowPopup(e); }
	public void mouseExited(MouseEvent e) {	}
	public void mouseEntered(MouseEvent e) { }
	
	public void maybeShowPopup(MouseEvent e)
	{
		if (e.isPopupTrigger())
		{
			try
			{
				rclickMenu.show(e.getComponent(), e.getX(), e.getY());
			}
			catch (Exception ex)
			{
				Debug.printException(ex);
			}
		}
	}
}
