/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

import org.mozdev.MacroTracker.main.MacroTracker;

import com.trfenv.rlk.Debug;

public class frmAbout extends JFrame
{
  JLabel aboutLabel;
  JButton aboutBtn;

  public frmAbout()
  {
    super( "About MacroTracker" );

	JLabel lblLogoPic = new JLabel(new ImageIcon(getClass().getResource("/images/logo.jpg")));
	lblLogoPic.setBorder(new LineBorder(Color.BLACK));
	lblLogoPic.setSize( 374, 105 );

    aboutLabel = new JLabel( "MacroTracker " + org.mozdev.MacroTracker.main.MacroTracker.VERSION );
    aboutBtn = new JButton( "OK" );

    JTextArea infoLabel = new JTextArea();
    infoLabel.setEditable( false );
    infoLabel.setLineWrap( true );
    infoLabel.setBackground(getBackground());
    infoLabel.setFont((new JLabel()).getFont());
    infoLabel.setText("Copyright (c) 2003-2004 R.J. Keller\n\nhttp://macrotracker.mozdev.org\n\nThis product is distributed under the Mozilla Public License version 1.1. To obtain a copy of the license, go to http://www.mozilla.org/MPL.\n\nrlk@trfenv.com");

	if (MacroTracker.IN_BETA)
	    aboutLabel.setText( aboutLabel.getText() + " Beta" );

    JPanel btnPanel = new JPanel();
    btnPanel.setLayout( new FlowLayout() );
    aboutBtn.addActionListener( new ActionListener(){
      public void actionPerformed(ActionEvent actionEvent)
      {
        setVisible( false );
      }
    });
    btnPanel.add( aboutBtn );

    this.getContentPane().setLayout( new BorderLayout() );
    this.getContentPane().add( lblLogoPic, BorderLayout.NORTH );
    this.getContentPane().add( new JScrollPane(infoLabel), BorderLayout.CENTER );
    this.getContentPane().add( btnPanel,   BorderLayout.SOUTH );

    pack();

    Debug.createObject(this);
  }

}