/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Stack;

import com.trfenv.rlk.Debug;

import java.io.IOException;

/**
 *This class loads a HTML file (taken in through the constructor) inside of a
 *browser window. URLs can be from the internet or a local HTML file. They
 *must be of content type text/html for it to work.
 *
 *@author R.J. Keller <rlk@trfenv.com>
 *@version 0.1
 */
public class frmMiniBrowser extends JFrame implements ActionListener
{
  private JEditorPane mContentsArea;
  
  private Stack forwardURL;
  private Stack backURL;
  
  private JButton forwardButton;
  private JButton backButton;
  private JButton homeButton;

  public frmMiniBrowser( String url )
  {
  	super("Browser");
    mContentsArea = new JEditorPane();
    mContentsArea.setEditable( false );
    mContentsArea.addHyperlinkListener(new HyperlinkListener()
    {
      public void hyperlinkUpdate( HyperlinkEvent event )
	  {
	  backURL.push(mContentsArea.getPage().toString());
	  
	  if ( event.getEventType() == HyperlinkEvent.EventType.ACTIVATED )
	    loadURL( event.getURL().toString() );
	  }
    });
    
    forwardURL = new Stack();
    backURL = new Stack();

    loadURL( url );
	getContentPane().setLayout(new BorderLayout());
    getContentPane().add( new JScrollPane( mContentsArea ), BorderLayout.CENTER );
    
    JToolBar navigationTlbr = new JToolBar();
    
    backButton = new JButton();
    forwardButton = new JButton();
    
    backButton.addActionListener(this);
    forwardButton.addActionListener(this);
    
    try
	{
		forwardButton.setIcon(new ImageIcon(frmMainScreen.class.getResource("/images/Forward24.gif"), "New Database"));
		backButton.setIcon(new ImageIcon(frmMainScreen.class.getResource("/images/Back24.gif"), "Open Database"));
	}
	catch (Exception ex)
	{
	    //If the images do not exist, inform the user.
	    Debug.printException(ex, "Couldn't load MiniBrowser image toolbar buttons.");

		JOptionPane.showMessageDialog( null, "An error has occured when loading the MacroTracker MiniBrowser. Try reinstalling MacroTracker to fix this issue.");
	}
	
	navigationTlbr.add(backButton);
	navigationTlbr.add(forwardButton);
	getContentPane().add(navigationTlbr, BorderLayout.NORTH);
    
    setSize( 700, 500 );

    Debug.createObject(this);
  }
  
  /**
   *Load a URL inside of the MiniBrowser.
   *@param location The URL you want to load in the minibrowser.
   */
  private void loadURL( String location )
  {
	Debug.println("Loading MiniBrowser URL: " + location);

    try
    {
      mContentsArea.setPage( location );
    }
    catch (IOException ioException )
    {
    }
  }
  
  public static void main(String[] arcs)
  {
  	frmMiniBrowser mini = new frmMiniBrowser( "file:///D:/Documents%20and%20Settings/Administrator/Desktop/j2sdk-1_4_2-doc/docs/api/index.html" );
  	mini.setVisible( true );
  	mini.setSize( 500, 500 );
  }
  
  public void actionPerformed(ActionEvent event)
  {
  	if (event.getSource() == forwardButton)
  	{
  		if (!forwardURL.isEmpty())
  		{
  			String forwardUrl = (String)forwardURL.pop();
  			backURL.push(forwardUrl);
  			
  			loadURL(forwardUrl);
  		}
  	}
  	else if (event.getSource() == backButton)
  	{
  		if (!backURL.isEmpty())
  		{
  			String backUrl = (String)backURL.pop();
  			forwardURL.push(backUrl);
  			
  			loadURL(backUrl);
  		}
  	}
  }
}
